/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.link.cost.collector;

import java.time.ZonedDateTime;

class CCostEntry {
    private final boolean mFix;
    private int mCosts;
    private ZonedDateTime mLastUpdate;

    CCostEntry(int aCosts, boolean aFix) {
        this.mCosts = aCosts;
        this.mFix = aFix;
        this.mLastUpdate = ZonedDateTime.now();
    }

    public int getCosts() {
        return this.mCosts;
    }

    public void setCosts(int aCosts) {
        this.mCosts = aCosts;
        this.mLastUpdate = ZonedDateTime.now();
    }

    public boolean isFix() {
        return this.mFix;
    }

    boolean canBeRemoved(int aTimeoutInSeconds) {
        ZonedDateTime maxTime = this.mLastUpdate.plusSeconds(aTimeoutInSeconds);
        ZonedDateTime now = ZonedDateTime.now();
        return now.isAfter(maxTime);
    }

    public ZonedDateTime getCostMeasureTime() {
        return this.mLastUpdate;
    }
}

