/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.collector.target;

import de.sillysky.nyssr.cli.ICommandLineInterface;
import de.sillysky.nyssr.impl.microservice.collector.IPrivateMicroServiceRegistryCollector;
import de.sillysky.nyssr.impl.microservice.collector.target.CTargetMicroServiceRegistryCollector;
import de.sillysky.nyssr.impl.microservice.collector.target.IDependencies;
import de.sillysky.nyssr.microservice.collector.IMicroServiceRegistryCollector;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.network.client.handling.IClientHandlingService;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplMicroServiceCollectorTarget
implements IServiceStarter,
IDependencies {
    private IService mService;
    private IRouter mRouter;
    private INamespaceFactory mNamespaceFactory;
    private IMicroServiceRegistryCollector mMicroServiceRegistryCollector;
    private IPrivateMicroServiceRegistryCollector mPrivateMicroServiceRegistryCollector;
    private IClientHandlingService mClientHandlingService;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IClientHandlingService.class);
        aDependencyList.add(IRouter.class);
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(IMicroServiceRegistryCollector.class);
        aDependencyList.add(IPrivateMicroServiceRegistryCollector.class);
        aDependencyList.add(ICommandLineInterface.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mRouter = (IRouter)aServiceRegistry.getServiceOrThrow(IRouter.class);
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
            this.mMicroServiceRegistryCollector = (IMicroServiceRegistryCollector)aServiceRegistry.getServiceOrThrow(IMicroServiceRegistryCollector.class);
            this.mPrivateMicroServiceRegistryCollector = (IPrivateMicroServiceRegistryCollector)aServiceRegistry.getServiceOrThrow(IPrivateMicroServiceRegistryCollector.class);
            this.mClientHandlingService = (IClientHandlingService)aServiceRegistry.getServiceOrThrow(IClientHandlingService.class);
            this.mService = new CTargetMicroServiceRegistryCollector(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public IRouter getRouter() {
        return this.mRouter;
    }

    @Override
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }

    @Override
    public IMicroServiceRegistryCollector getMicroServiceRegistryCollector() {
        return this.mMicroServiceRegistryCollector;
    }

    @Override
    public IPrivateMicroServiceRegistryCollector getPrivateMicroServiceRegistryCollector() {
        return this.mPrivateMicroServiceRegistryCollector;
    }

    @Override
    public IClientHandlingService getClientHandlingService() {
        return this.mClientHandlingService;
    }
}

