/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.microservice.registry.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordGetMicroServiceInstance
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"ddadb3e0-98b9-4e59-849d-369b079cbc1d");
    public static final String NAME = "GetMicroServiceInstance";
    public static final String DESCRIPTION = "Get the target address of the given Micro Service ID. If more than one instance is registered, a random instance is chosen.";
    public static final String SLOT_MICRO_SERVICE_ID = "1";
    public static final String SLOT_OWNER = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static IId getMicroServiceId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MICRO_SERVICE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CTargetAddress getOwner(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_OWNER);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static void setMicroServiceId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_MICRO_SERVICE_ID, slot);
    }

    public static void setOwner(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_OWNER, slot);
    }
}

