/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonBoolean;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.enums.ETableSelectionMode;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTableSelectionMode
implements IRemoteSkinEvent {
    private static final String CELL_SELECTION_ENABLED = "cellselectionenabled";
    private static final String COLUMN_SELECTION_MODE = "columnselectionmode";
    private static final String ROW_SELECTION_MODE = "rowselectionmode";
    private static final boolean DEFAULT_CELL_SELECTION_ENABLED = false;
    private static final ETableSelectionMode DEFAULT_COLUMN_SELECTION_MODE = ETableSelectionMode.disabled;
    private static final ETableSelectionMode DEFAULT_ROW_SELECTION_MODE = ETableSelectionMode.single;
    private final boolean mCellSelectionEnabled;
    private final ETableSelectionMode mColumnSelectionMode;
    private final ETableSelectionMode mRowSelectionMode;

    public CEventTableSelectionMode(boolean aCellSelectionEnabled, @NotNull ETableSelectionMode aColumnSelectionMode, @NotNull ETableSelectionMode aRowSelectionMode) {
        this.mCellSelectionEnabled = aCellSelectionEnabled;
        this.mColumnSelectionMode = aColumnSelectionMode;
        this.mRowSelectionMode = aRowSelectionMode;
    }

    @Nullable
    public static CEventTableSelectionMode create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            boolean cellSelectionEnabled = CUtilJsonBoolean.fromJson((CJsonObject)jo, (String)CELL_SELECTION_ENABLED, (boolean)false);
            String s = CUtilJsonString.fromJson((CJsonObject)jo, (String)COLUMN_SELECTION_MODE, (String)DEFAULT_COLUMN_SELECTION_MODE.name());
            ETableSelectionMode columnSelectionMode = (ETableSelectionMode)((Object)CUtilEnum.fromString(ETableSelectionMode.class, (String)s, (Object)((Object)DEFAULT_COLUMN_SELECTION_MODE)));
            s = CUtilJsonString.fromJson((CJsonObject)jo, (String)ROW_SELECTION_MODE, (String)DEFAULT_ROW_SELECTION_MODE.name());
            ETableSelectionMode rowSelectionMode = (ETableSelectionMode)((Object)CUtilEnum.fromString(ETableSelectionMode.class, (String)s, (Object)((Object)DEFAULT_ROW_SELECTION_MODE)));
            return new CEventTableSelectionMode(cellSelectionEnabled, columnSelectionMode, rowSelectionMode);
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(CELL_SELECTION_ENABLED, (Object)this.mCellSelectionEnabled);
        jo.put(COLUMN_SELECTION_MODE, (Object)this.mColumnSelectionMode);
        jo.put(ROW_SELECTION_MODE, (Object)this.mRowSelectionMode);
        return jo;
    }

    public boolean isCellSelectionEnabled() {
        return this.mCellSelectionEnabled;
    }

    @NotNull
    public ETableSelectionMode getColumnSelectionMode() {
        return this.mColumnSelectionMode;
    }

    @NotNull
    public ETableSelectionMode getRowSelectionMode() {
        return this.mRowSelectionMode;
    }
}

