/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelAttributes;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilBoolean;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTableCell
implements IRemoteSkinEvent {
    private static final String COLUMN_ID = "columnId";
    private static final String ROW_ID = "rowId";
    private static final String RESET = "reset";
    private final String mColumnId;
    private final String mRowId;
    private final CEventLabelAttributes mLabelAttributes;
    private Boolean mReset;

    public CEventTableCell(@NotNull String aColumnId, @NotNull String aRowId) {
        this.mColumnId = aColumnId;
        this.mRowId = aRowId;
        this.mLabelAttributes = new CEventLabelAttributes();
    }

    private CEventTableCell(@NotNull String aColumnId, @NotNull String aRowId, @Nullable CEventLabelAttributes aLabelAttributes) {
        this.mColumnId = aColumnId;
        this.mRowId = aRowId;
        this.mLabelAttributes = aLabelAttributes == null ? new CEventLabelAttributes() : aLabelAttributes;
    }

    @Nullable
    public static CEventTableCell create(@Nullable Object aValue) {
        String rowId;
        CJsonObject jo;
        Object o;
        String columnId;
        if (aValue instanceof CJsonObject && CUtilString.isValid((String)(columnId = CUtilString.fromObject((Object)(o = (jo = (CJsonObject)aValue).getValue(COLUMN_ID)), null))) && CUtilString.isValid((String)(rowId = CUtilString.fromObject((Object)(o = jo.getValue(ROW_ID)), null)))) {
            CEventLabelAttributes widgetItem = CEventLabelAttributes.create(aValue);
            CEventTableCell event = new CEventTableCell(columnId, rowId, widgetItem);
            o = jo.getValue(RESET);
            if (o != null) {
                boolean reset = CUtilBoolean.fromObject((Object)o, (boolean)true);
                event.setReset(reset);
            }
            return event;
        }
        return null;
    }

    @NotNull
    public String getColumnId() {
        return this.mColumnId;
    }

    @NotNull
    public String getRowId() {
        return this.mRowId;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(COLUMN_ID, (Object)this.mColumnId);
        jo.put(ROW_ID, (Object)this.mRowId);
        this.mLabelAttributes.toJson(jo);
        if (this.mReset != null) {
            jo.put(RESET, (Object)this.mReset);
        }
        return jo;
    }

    @Nullable
    public Boolean shallResetBefore() {
        return this.mReset;
    }

    public void setReset(Boolean aReset) {
        this.mReset = aReset;
    }

    @NotNull
    public CEventLabelAttributes getLabelAttributes() {
        return this.mLabelAttributes;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CEventTableCell cell = (CEventTableCell)aO;
        return this.mColumnId.equals(cell.mColumnId) && this.mRowId.equals(cell.mRowId);
    }

    public int hashCode() {
        return Objects.hash(this.mColumnId, this.mRowId);
    }
}

