/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.time.CUtilLocalDateTime;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventDateFormat
implements IRemoteSkinEvent {
    private static final String DATE = "date";
    private static final String FORMAT = "format";
    private final String mDateString;
    private final String mFormatString;

    public CEventDateFormat(String aDateString, String aFormatString) {
        this.mDateString = aDateString;
        this.mFormatString = aFormatString;
    }

    @Nullable
    public static CEventDateFormat create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String dateString = CUtilJsonString.fromJson((CJsonObject)jo, (String)DATE, (String)"");
            String formatString = CUtilJsonString.fromJson((CJsonObject)jo, (String)FORMAT, (String)"");
            return new CEventDateFormat(dateString, formatString);
        }
        return null;
    }

    public String getDateString() {
        return this.mDateString;
    }

    public String getFormatString() {
        return this.mFormatString;
    }

    public LocalDate createLocalDate() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(this.mFormatString);
        return LocalDate.parse(this.mDateString, dtf);
    }

    public LocalDateTime createLocalDateTime() {
        return CUtilLocalDateTime.fromString((String)this.mDateString, (String)this.mFormatString);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(DATE, (Object)this.mDateString);
        jo.put(FORMAT, (Object)this.mFormatString);
        return jo;
    }
}

