/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CExceptionLogger;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class CAttributeTemplateList {
    public static final String DELIMITER = ",";
    private static final ILogger LOG = CLoggerFactory.getLogger(CAttributeTemplateList.class);
    private final Map<String, CJsonObject> mTemplates = new ConcurrentHashMap<String, CJsonObject>();

    @NotNull
    public static List<String> parse(@NotNull String aList) {
        ArrayList<String> templates = new ArrayList<String>();
        for (String t : aList.split(DELIMITER)) {
            templates.add(t.trim().toLowerCase());
        }
        return templates;
    }

    public CJsonObject getTemplate(@NotNull String aName) {
        return this.mTemplates.get(aName.toLowerCase());
    }

    public void addTemplate(@NotNull String aName, @NotNull CJsonObject aTemplate) {
        this.mTemplates.put(aName.trim().toLowerCase(), aTemplate);
    }

    public void merge(@NotNull CJsonObject aMainJsonObject) throws CException {
        Object o = aMainJsonObject.getValue("templates");
        if (o instanceof String) {
            List<String> list = CAttributeTemplateList.parse((String)o);
            for (String templateName : list) {
                LOG.debug("Merge template {}", new Object[]{templateName});
                CJsonObject template = this.getTemplate(templateName);
                if (template == null) {
                    CExceptionLogger.logAndThrow(CAttributeTemplateList.class, (int)5006, (String)"Template {0} not found", (Object[])new Object[]{templateName});
                    continue;
                }
                CJsonObject jo = this.merge2(template, aMainJsonObject);
                aMainJsonObject.clear();
                for (String key : jo.keys()) {
                    aMainJsonObject.put(key, jo.getValue(key));
                }
            }
        }
    }

    public CJsonObject merge2(@NotNull CJsonObject aTemplate, @NotNull CJsonObject aMainJsonObject) {
        CJsonObject newRootObject = new CJsonObject();
        Collection keys = aTemplate.keys();
        for (String key : keys) {
            Object templateValue = aTemplate.getValue(key);
            if (templateValue instanceof CJsonObject) {
                newRootObject.put(key, (Object)((CJsonObject)templateValue).getCopy());
                continue;
            }
            if (templateValue instanceof CJsonArray) {
                newRootObject.put(key, (Object)((CJsonArray)templateValue).getCopy());
                continue;
            }
            newRootObject.put(key, templateValue);
        }
        keys = aMainJsonObject.keys();
        for (String key : keys) {
            Object originValue = aMainJsonObject.getValue(key);
            if (originValue == null) continue;
            Object newValue = newRootObject.getValue(key);
            if (newValue == null) {
                newRootObject.put(key, originValue);
                continue;
            }
            this.merge(originValue, newRootObject);
        }
        return newRootObject;
    }

    public void merge(@NotNull Object aSrc, @NotNull Object aDest) {
        block4: {
            block3: {
                if (!(aSrc instanceof CJsonObject) || !(aDest instanceof CJsonObject)) break block3;
                CJsonObject src = (CJsonObject)aSrc;
                CJsonObject dest = (CJsonObject)aDest;
                Collection keys = src.keys();
                for (String key : keys) {
                    Object oSrc = src.getValue(key);
                    Object oDest = dest.getValue(key);
                    if (oDest == null) {
                        dest.put(key, oSrc);
                        continue;
                    }
                    if ((!(oSrc instanceof CJsonObject) || !(oDest instanceof CJsonObject)) && (!(oSrc instanceof CJsonArray) || !(oDest instanceof CJsonArray))) continue;
                    this.merge(oSrc, oDest);
                }
                break block4;
            }
            if (!(aSrc instanceof CJsonArray) || !(aDest instanceof CJsonArray)) break block4;
            CJsonArray src = (CJsonArray)aSrc;
            CJsonArray dest = (CJsonArray)aDest;
            for (Object srcChild : src.getChildren()) {
                dest.add(srcChild);
            }
        }
    }
}

