/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.widget.parser.raw;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.remoteskin.widget.parser.raw.CWidgetEntry;
import de.sillysky.nyssr.impl.remoteskin.widget.parser.raw.CWidgetEntryList;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CAttributeTemplateList;
import org.jetbrains.annotations.NotNull;

class CWidgetParser {
    private CWidgetParser() {
    }

    static void parse(@NotNull CWidgetEntryList aEntryList, @NotNull CAttributeTemplateList aTemplateList, @NotNull CJsonArray aArray) throws CException {
        for (Object o : aArray.getChildren()) {
            if (!(o instanceof CJsonObject)) continue;
            CWidgetParser.parseWidgetObject(aEntryList, aTemplateList, (CJsonObject)o);
        }
    }

    private static void parseWidgetObject(@NotNull CWidgetEntryList aEntryList, @NotNull CAttributeTemplateList aTemplateList, @NotNull CJsonObject aJsonObject) throws CException {
        String id = CWidgetParser.readId(aJsonObject);
        String widgetType = CWidgetParser.readWidgetType(id, aJsonObject);
        CWidgetEntry entry = new CWidgetEntry(id, widgetType);
        aTemplateList.merge(aJsonObject);
        entry.setAttributes(aJsonObject);
        aEntryList.add(entry);
    }

    @NotNull
    private static String readWidgetType(String aId, @NotNull CJsonObject aJsonObject) throws CException {
        Object o = aJsonObject.getValue("widgetType");
        if (!(o instanceof String)) {
            throw new CException(8).append("Widget has no widgetType: ID=").append(aId);
        }
        String widgetType = (String)o;
        return widgetType;
    }

    @NotNull
    private static String readId(@NotNull CJsonObject aJsonObject) throws CException {
        Object o = aJsonObject.getValue("id");
        if (!(o instanceof String)) {
            throw new CException(8).append("Widget has no ID");
        }
        String id = (String)o;
        return id;
    }
}

