/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.server.context;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.remoteskin.server.context.CRemoteSkinServerListenerList;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CModelConstants;
import de.sillysky.nyssr.remoteskin.model.command.IJsonCommandSender;
import de.sillysky.nyssr.remoteskin.model.enums.EComponentOrientation;
import de.sillysky.nyssr.remoteskin.model.enums.EListBoxLayout;
import de.sillysky.nyssr.remoteskin.model.enums.EListSelectionMode;
import de.sillysky.nyssr.remoteskin.model.enums.EPosition;
import de.sillysky.nyssr.remoteskin.model.enums.ERelation;
import de.sillysky.nyssr.remoteskin.model.enums.ETableAutoResize;
import de.sillysky.nyssr.remoteskin.model.enums.ETableSelectionMode;
import de.sillysky.nyssr.remoteskin.model.enums.ETreeSelectionMode;
import de.sillysky.nyssr.remoteskin.model.enums.EWidgetOrientation;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventComboBoxContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventComponentOrientation;
import de.sillysky.nyssr.remoteskin.model.events.CEventCreateWidget;
import de.sillysky.nyssr.remoteskin.model.events.CEventDimension;
import de.sillysky.nyssr.remoteskin.model.events.CEventEnsureVisible;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.CEventHorizontalAlignment;
import de.sillysky.nyssr.remoteskin.model.events.CEventHorizontalTextPosition;
import de.sillysky.nyssr.remoteskin.model.events.CEventHtml;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcons;
import de.sillysky.nyssr.remoteskin.model.events.CEventInsertMenuItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventInsertText;
import de.sillysky.nyssr.remoteskin.model.events.CEventInsertTreeNode;
import de.sillysky.nyssr.remoteskin.model.events.CEventListBoxLayout;
import de.sillysky.nyssr.remoteskin.model.events.CEventListContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionMode;
import de.sillysky.nyssr.remoteskin.model.events.CEventLocalDateTime;
import de.sillysky.nyssr.remoteskin.model.events.CEventMargin;
import de.sillysky.nyssr.remoteskin.model.events.CEventRectangle;
import de.sillysky.nyssr.remoteskin.model.events.CEventRemoveWidget;
import de.sillysky.nyssr.remoteskin.model.events.CEventReplaceText;
import de.sillysky.nyssr.remoteskin.model.events.CEventSelectItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventSelectItems;
import de.sillysky.nyssr.remoteskin.model.events.CEventSelectText;
import de.sillysky.nyssr.remoteskin.model.events.CEventSetRowHeight;
import de.sillysky.nyssr.remoteskin.model.events.CEventTabProperties;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableCell;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableColumn;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableHeader;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableHeaders;
import de.sillysky.nyssr.remoteskin.model.events.CEventTableSelectionMode;
import de.sillysky.nyssr.remoteskin.model.events.CEventText;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeNode;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeSelectionMode;
import de.sillysky.nyssr.remoteskin.model.events.CEventUnmountWidget;
import de.sillysky.nyssr.remoteskin.model.events.CEventUpdateComboBox;
import de.sillysky.nyssr.remoteskin.model.events.CEventVerticalAlignment;
import de.sillysky.nyssr.remoteskin.model.events.CEventVerticalTextPosition;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetOrientation;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventBevelBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventCompoundBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventDashedBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventEmptyBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventEtchedBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventLineBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventMatteBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventStrokeBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventTitledBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowColorChooserDialog;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowFileChooserDialog;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowInputDialog;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowMessageDialog;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowSelectDialog;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventBorderLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventBoxLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventCardLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventFlowLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventGridBagLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventGridLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventMigLayout;
import de.sillysky.nyssr.remoteskin.model.names.EPrivateWidgetNames;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.util.swing.time.CUtilCalendarUnit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CWidgetApi
implements IWidgetApi {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWidgetApi.class);
    private final CRemoteSkinServerListenerList mListeners = new CRemoteSkinServerListenerList();
    private IJsonCommandSender mSender;

    public CWidgetApi(IJsonCommandSender aSender) {
        this.mSender = aSender;
    }

    public void activateTab(@NotNull CWidgetId aWidgetId, @NotNull String aTabTitle) {
        this.addAttribute(aWidgetId, "activateTab", aTabTitle);
    }

    public void addListener(@NotNull UUID aTransactionId, @NotNull IListener aListener) {
        this.mListeners.add(aTransactionId, aListener);
    }

    public void addListener(@NotNull CWidgetId aWidgetId, @NotNull IListener aListener) {
        this.mListeners.add(aWidgetId, aListener);
    }

    public void addListener(@NotNull CWidgetSetId aWidgetSetId, @NotNull IListener aListener) {
        this.mListeners.add(CWidgetId.create((String)EPrivateWidgetNames.widgetSet.name(), (CWidgetSetId)aWidgetSetId), aListener);
    }

    public void addTableColumn(@NotNull CWidgetId aWidgetId, @NotNull CEventTableColumn aEvent) {
        this.addEvent(aWidgetId, "addTableColumn", (IRemoteSkinEvent)aEvent);
    }

    public void alterTableColumn(@NotNull CWidgetId aWidgetId, @NotNull CEventTableColumn aEvent) {
        this.addEvent(aWidgetId, "alterTableColumn", (IRemoteSkinEvent)aEvent);
    }

    public void centerWidget(@NotNull CWidgetId aWidgetIdToCenter, @NotNull CWidgetId aWidgetIdBelow) {
        CEventWidgetId event = new CEventWidgetId(aWidgetIdBelow);
        this.addAttribute(aWidgetIdToCenter, "centerWindowToWidget", event.toJson());
    }

    public void centerWidgetOnScreen(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "centerWindowToScreen", true);
    }

    public void clear(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "clear", true);
    }

    public void collapse(@NotNull CWidgetId aWidgetId, @NotNull String aItemId) {
        this.addAttribute(aWidgetId, "collapse", aItemId);
    }

    public void copy(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "copy", true);
    }

    public void createWidget(@NotNull CEventCreateWidget aEvent) {
        this.addEvent(CModelConstants.CONTEXT_WIDGET_ID, "createwidget", (IRemoteSkinEvent)aEvent);
    }

    public void cut(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "cut", true);
    }

    public void doClick(@NotNull CWidgetId aWidgetId, int aPressTime) {
        this.addAttribute(aWidgetId, "doClick", aPressTime);
    }

    public void enableWordWrapStyle(@NotNull CWidgetId aWidgetId, boolean aEnable) {
        this.addAttribute(aWidgetId, "wordWrapStyle", aEnable);
    }

    public void ensureVisible(@NotNull CWidgetId aWidgetId, @NotNull CEventEnsureVisible aEvent) {
        this.addEvent(aWidgetId, "ensureVisible", (IRemoteSkinEvent)aEvent);
    }

    public void insertMenuItem(@NotNull CWidgetId aWidgetId, @NotNull CEventInsertMenuItem aEvent) {
        this.addEvent(aWidgetId, "insertMenuItem", (IRemoteSkinEvent)aEvent);
    }

    public void insertText(@NotNull CWidgetId aWidgetId, @NotNull CEventInsertText aEvent) {
        this.addEvent(aWidgetId, "insertText", (IRemoteSkinEvent)aEvent);
    }

    public void invalidate(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "invalidate", true);
    }

    public void expand(@NotNull CWidgetId aWidgetId, @NotNull String aItemId) {
        this.addAttribute(aWidgetId, "expand", aItemId);
    }

    public void insertTreeNode(@NotNull CWidgetId aWidgetId, @NotNull CEventTreeNode aNode, @NotNull ERelation aRelation, @NotNull String aRelatedNoteId) {
        CEventInsertTreeNode event = new CEventInsertTreeNode(aNode, aRelatedNoteId, aRelation);
        this.addEvent(aWidgetId, "treeInsertNode", (IRemoteSkinEvent)event);
    }

    public void makeTreeNodeViewable(@NotNull CWidgetId aWidgetId, @NotNull String aNodeId) {
        this.addAttribute(aWidgetId, "treeMakeNodeViewable", aNodeId);
    }

    public void moveToolbar(@NotNull CWidgetId aWidgetId, @NotNull EPosition aBorderConstraints) {
        this.addAttribute(aWidgetId, "moveToolbar", aBorderConstraints.name());
    }

    public void pack(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "pack", true);
    }

    public void paste(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "paste", true);
    }

    public void print(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "print", true);
    }

    public void removeWidget(@NotNull CEventRemoveWidget aEvent) {
        this.addAttribute(CModelConstants.CONTEXT_WIDGET_ID, "removewidget", aEvent.toJson());
    }

    public void repaint(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "repaint", true);
    }

    public void replaceSelection(@NotNull CWidgetId aWidgetId, @NotNull String aText) {
        this.addAttribute(aWidgetId, "replaceSelection", aText);
    }

    public void replaceText(@NotNull CWidgetId aWidgetId, @NotNull CEventReplaceText aEvent) {
        this.addEvent(aWidgetId, "replaceText", (IRemoteSkinEvent)aEvent);
    }

    public void revalidate(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "revalidate", true);
    }

    public void selectItem(@NotNull CWidgetId aWidgetId, @NotNull String aSelection) {
        this.addAttribute(aWidgetId, "selectItem", new CEventSelectItem(aSelection).toJson());
    }

    public void selectItems(@NotNull CWidgetId aWidgetId, @NotNull Collection<String> aNodeIds) {
        this.addAttribute(aWidgetId, "selectItem", new CEventSelectItems().addIds(aNodeIds).toJson());
    }

    public void selectText(@NotNull CWidgetId aWidgetId, @NotNull CEventSelectText aEvent) {
        this.addEvent(aWidgetId, "selectText", (IRemoteSkinEvent)aEvent);
    }

    public void scrollRectToVisible(@NotNull CWidgetId aWidgetId, @NotNull Rectangle aRectangle) {
        CEventRectangle event = new CEventRectangle(aRectangle);
        this.addAttribute(aWidgetId, "scrollRectToVisible", event.toJson());
    }

    public void setAlignmentX(@NotNull CWidgetId aWidgetId, float aAlignment) {
        this.addAttribute(aWidgetId, "alignmentX", Float.valueOf(aAlignment));
    }

    public void setAlignmentY(@NotNull CWidgetId aWidgetId, float aAlignment) {
        this.addAttribute(aWidgetId, "alignmentY", Float.valueOf(aAlignment));
    }

    public void setAutoLineWrap(@NotNull CWidgetId aWidgetId, boolean aEnable) {
        this.addAttribute(aWidgetId, "autoLineWrap", aEnable);
    }

    public void setBackgroundColor(@NotNull CWidgetId aWidgetId, @NotNull CEventColor aEvent) {
        this.addEvent(aWidgetId, "background", (IRemoteSkinEvent)aEvent);
    }

    public void setBevelBorder(@NotNull CWidgetId aWidgetId, @NotNull CEventBevelBorder aEvent) {
        this.addEvent(aWidgetId, "bevelBorder", (IRemoteSkinEvent)aEvent);
    }

    public void setMultiClickThreshold(@NotNull CWidgetId aWidgetId, long aThreshold) {
        this.addAttribute(aWidgetId, "multiClickThreshold", aThreshold);
    }

    public void setBorderLayout(@NotNull CWidgetId aWidgetId, @NotNull CEventBorderLayout aEvent) {
        this.addEvent(aWidgetId, "borderLayout", (IRemoteSkinEvent)aEvent);
    }

    public void setBorderPainted(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "borderPainted", aEnabled);
    }

    public void setBorderPaintedFlat(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "borderPaintedFlat", aEnabled);
    }

    public void setBoxLayout(@NotNull CWidgetId aWidgetId, @NotNull CEventBoxLayout aEvent) {
        this.addEvent(aWidgetId, "boxLayout", (IRemoteSkinEvent)aEvent);
    }

    public void setCardLayout(@NotNull CWidgetId aWidgetId, @NotNull CEventCardLayout aEvent) {
        this.addEvent(aWidgetId, "cardLayout", (IRemoteSkinEvent)aEvent);
    }

    public void setCalendarUnit(@NotNull CWidgetId aWidgetId, @NotNull String aValue) {
        this.addAttribute(aWidgetId, "calendarUnit", aValue);
    }

    public void setCaretColor(@NotNull CWidgetId aWidgetId, @NotNull CEventColor aEvent) {
        this.addEvent(aWidgetId, "caretColor", (IRemoteSkinEvent)aEvent);
    }

    public void setCaretPosition(@NotNull CWidgetId aWidgetId, int aPosition) {
        this.addAttribute(aWidgetId, "caretPosition", aPosition);
    }

    public void setCalendarUnit(@NotNull CWidgetId aWidgetId, int aValue) {
        String s = CUtilCalendarUnit.getMap().get(aValue);
        this.addAttribute(aWidgetId, "calendarUnit", s);
    }

    public void setColumns(@NotNull CWidgetId aWidgetId, @NotNull String[] aColumns) {
        CJsonArray arr = new CJsonArray();
        for (String col : aColumns) {
            arr.add((Object)col);
        }
        this.setColumns(aWidgetId, arr);
    }

    public void setColumns(@NotNull CWidgetId aWidgetId, @NotNull Collection<String> aColumns) {
        CJsonArray arr = new CJsonArray();
        for (String col : aColumns) {
            arr.add((Object)col);
        }
        this.setColumns(aWidgetId, arr);
    }

    public void setColumns(@NotNull CWidgetId aWidgetId, @NotNull CJsonArray aColumns) {
        this.addAttribute(aWidgetId, "columns", aColumns);
    }

    public void setComboData(@NotNull CWidgetId aWidgetId, @NotNull CEventComboBoxContent aContent) {
        Object jo = aContent.toJson();
        this.addAttribute(aWidgetId, "data", jo);
    }

    public void setComponentOrientation(@NotNull CWidgetId aWidgetId, @NotNull EComponentOrientation aComponentOrientation) {
        CEventComponentOrientation event = new CEventComponentOrientation(aComponentOrientation);
        this.addEvent(aWidgetId, "componentOrientation", (IRemoteSkinEvent)event);
    }

    public void setCompoundBorder(@NotNull CWidgetId aWidgetId, @NotNull IBorder aOuterBorder, @NotNull IBorder aInnerBorder) {
        CEventCompoundBorder event = new CEventCompoundBorder(aOuterBorder, aInnerBorder);
        CJsonObject jo = event.toJson();
        this.addAttribute(aWidgetId, "compoundBorder", jo);
    }

    public void setContentAreaFilled(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "contentAreaFilled", aEnabled);
    }

    public void setDisabledTextColor(@NotNull CWidgetId aWidgetId, @NotNull CEventColor aEvent) {
        this.addEvent(aWidgetId, "disabledTextColor", (IRemoteSkinEvent)aEvent);
    }

    public void setFlowLayout(@NotNull CWidgetId aWidgetId, @NotNull CEventFlowLayout aEvent) {
        this.addEvent(aWidgetId, "flowLayout", (IRemoteSkinEvent)aEvent);
    }

    public void setGridBagLayout(@NotNull CWidgetId aWidgetId) {
        this.addEvent(aWidgetId, "gridBagLayout", (IRemoteSkinEvent)new CEventGridBagLayout());
    }

    public void setGridLayout(@NotNull CWidgetId aWidgetId, @NotNull CEventGridLayout aEvent) {
        this.addEvent(aWidgetId, "gridLayout", (IRemoteSkinEvent)new CEventGridLayout());
    }

    public void setIndeterminateMode(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "indeterminateMode", aEnabled);
    }

    public void setListBoxLayout(@NotNull CWidgetId aWidgetId, @NotNull EListBoxLayout aListBoxLayout) {
        this.addEvent(aWidgetId, "listBoxLayout", (IRemoteSkinEvent)new CEventListBoxLayout(aListBoxLayout));
    }

    public void setListSelectionMode(@NotNull CWidgetId aWidgetId, @NotNull EListSelectionMode aMode) {
        this.addEvent(aWidgetId, "listSelectionMode", (IRemoteSkinEvent)new CEventListSelectionMode(aMode));
    }

    public void setMaximumSize(@NotNull CWidgetId aWidgetId, @Nullable Dimension aDimension) {
        CEventDimension event = new CEventDimension(aDimension);
        this.addEvent(aWidgetId, "maximumSize", (IRemoteSkinEvent)event);
    }

    public void setMigLayout(@NotNull CWidgetId aWidgetId, @NotNull CEventMigLayout aEvent) {
        this.addEvent(aWidgetId, "migLayout", (IRemoteSkinEvent)aEvent);
    }

    public void setMinimumSize(@NotNull CWidgetId aWidgetId, @Nullable Dimension aDimension) {
        CEventDimension event = new CEventDimension(aDimension);
        this.addEvent(aWidgetId, "minimumSize", (IRemoteSkinEvent)event);
    }

    public void setOpaque(@NotNull CWidgetId aWidgetId, boolean aOpaque) {
        this.addAttribute(aWidgetId, "opaque", aOpaque);
    }

    public void setPreferredSize(@NotNull CWidgetId aWidgetId, @Nullable Dimension aDimension) {
        CEventDimension event = new CEventDimension(aDimension);
        this.addEvent(aWidgetId, "preferredSize", (IRemoteSkinEvent)event);
    }

    public void setDefaultCapable(@NotNull CWidgetId aWidgetId, boolean aCapable) {
        this.addAttribute(aWidgetId, "defaultCapable", aCapable);
    }

    public void setDelay(@NotNull CWidgetId aWidgetId, int aDelay) {
        this.addAttribute(aWidgetId, "delay", aDelay);
    }

    public void setDashedBorder(@NotNull CWidgetId aWidgetId, @NotNull CEventDashedBorder aEvent) {
        this.addEvent(aWidgetId, "dashedBorder", (IRemoteSkinEvent)aEvent);
    }

    public void setDate(@NotNull CWidgetId aWidgetId, @NotNull LocalDateTime aValue) {
        CEventLocalDateTime event = new CEventLocalDateTime(aValue);
        this.addAttribute(aWidgetId, "date", event.toJson());
    }

    public void setDateTimeFormat(@NotNull CWidgetId aWidgetId, @NotNull String aValue) {
        this.addAttribute(aWidgetId, "dateTimeFormat", aValue);
    }

    public void setDisplay(@NotNull CWidgetId aWidgetId, String aWidgetName) {
        this.addAttribute(aWidgetId, "display", aWidgetName);
    }

    public void setEditable(@NotNull CWidgetId aWidgetId, boolean aEditable) {
        this.addAttribute(aWidgetId, "editable", aEditable);
    }

    public void setEnabled(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "enabled", aEnabled);
    }

    public void setFixedCellHeight(@NotNull CWidgetId aWidgetId, int aHeight) {
        this.addAttribute(aWidgetId, "fixedCellHeight", aHeight);
    }

    public void setFixedCellWidth(@NotNull CWidgetId aWidgetId, int aWidth) {
        this.addAttribute(aWidgetId, "fixedCellWidth", aWidth);
    }

    public void setFloatable(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "floatable", aEnabled);
    }

    public void setEmptyBorder(@NotNull CWidgetId aWidgetId, int aAll) {
        CEventEmptyBorder data = new CEventEmptyBorder(aAll);
        this.addAttribute(aWidgetId, "emptyBorder", data.toJson());
    }

    public void setEmptyBorder(@NotNull CWidgetId aWidgetId, int aTop, int aRight, int aBottom, int aLeft) {
        CEventEmptyBorder data = new CEventEmptyBorder(aTop, aLeft, aBottom, aRight);
        this.addAttribute(aWidgetId, "emptyBorder", data.toJson());
    }

    public void setEtchedBorder(@NotNull CWidgetId aWidgetId, @NotNull CEventEtchedBorder aEvent) {
        this.addEvent(aWidgetId, "etchedBorder", (IRemoteSkinEvent)aEvent);
    }

    public void setFinish(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "finish", true);
    }

    public void setForegroundColor(@NotNull CWidgetId aWidgetId, @NotNull CEventColor aEvent) {
        this.addEvent(aWidgetId, "foreground", (IRemoteSkinEvent)aEvent);
    }

    public void setHasTableHeader(@NotNull CWidgetId aWidgetId, boolean aHasHeader) {
        this.addAttribute(aWidgetId, "hasTableHeader", aHasHeader);
    }

    public void setHeightInCharacters(@NotNull CWidgetId aWidgetId, int aCount) {
        this.addAttribute(aWidgetId, "heightInCharacters", aCount);
    }

    public void setHorizontalAlignment(@NotNull CWidgetId aWidgetId, @NotNull CEventHorizontalAlignment aEvent) {
        this.addEvent(aWidgetId, "horizontalAlignment", (IRemoteSkinEvent)aEvent);
    }

    public void setHorizontalTextPosition(@NotNull CWidgetId aWidgetId, @NotNull CEventHorizontalTextPosition aEvent) {
        this.addEvent(aWidgetId, "horizontalTextPosition", (IRemoteSkinEvent)aEvent);
    }

    public void setHtml(@NotNull CWidgetId aWidgetId, @NotNull String aText) {
        CEventHtml event = new CEventHtml(aText);
        Object json = event.toJson();
        this.addAttribute(aWidgetId, "html", json);
    }

    public void setIcon(@NotNull CWidgetId aWidgetId, @NotNull CEventIcon aEvent) {
        this.addEvent(aWidgetId, "icon", (IRemoteSkinEvent)aEvent);
    }

    public void setIcons(@NotNull CWidgetId aWidgetId, @NotNull CEventIcons aIcons) {
        this.addEvent(aWidgetId, "icon", (IRemoteSkinEvent)aIcons);
    }

    public void setIconTextGap(@NotNull CWidgetId aWidgetId, int aGap) {
        this.addAttribute(aWidgetId, "iconTextGap", aGap);
    }

    public void setLabelFor(@NotNull CWidgetId aWidgetId, @NotNull String aWidgetName) {
        this.addAttribute(aWidgetId, "labelFor", aWidgetName);
    }

    public void setLineBorder(@NotNull CWidgetId aWidgetId, @NotNull CEventLineBorder aEvent) {
        this.addEvent(aWidgetId, "lineBorder", (IRemoteSkinEvent)aEvent);
    }

    public void setListContent(@NotNull CWidgetId aWidgetId, @NotNull CEventListContent aEvent) {
        this.addAttribute(aWidgetId, "data", aEvent.toJson());
    }

    public void setMatteBorder(@NotNull CWidgetId aWidgetId, @NotNull CEventMatteBorder aEvent) {
        this.addEvent(aWidgetId, "matteBorder", (IRemoteSkinEvent)aEvent);
    }

    public void setMargin(@NotNull CWidgetId aWidgetId, @NotNull CEventMargin aEventMargin) {
        this.addEvent(aWidgetId, "margin", (IRemoteSkinEvent)aEventMargin);
    }

    public void setMaximum(@NotNull CWidgetId aWidgetId, @NotNull LocalDateTime aMaximum) {
        CEventLocalDateTime event = new CEventLocalDateTime(aMaximum);
        this.addAttribute(aWidgetId, "maximumDate", event.toJson());
    }

    public void setMaximum(@NotNull CWidgetId aWidgetId, double aMaximum) {
        this.addAttribute(aWidgetId, "maximumDouble", aMaximum);
    }

    public void setMaximum(@NotNull CWidgetId aWidgetId, int aMaximum) {
        this.addAttribute(aWidgetId, "maximumInt", aMaximum);
    }

    public void setMinimum(@NotNull CWidgetId aWidgetId, @NotNull LocalDateTime aMinimum) {
        CEventLocalDateTime event = new CEventLocalDateTime(aMinimum);
        this.addAttribute(aWidgetId, "minimumDate", event.toJson());
    }

    public void setMinimum(@NotNull CWidgetId aWidgetId, double aMinimum) {
        this.addAttribute(aWidgetId, "minimumDouble", aMinimum);
    }

    public void setMinimum(@NotNull CWidgetId aWidgetId, int aMinimum) {
        this.addAttribute(aWidgetId, "minimumInt", aMinimum);
    }

    public void setMnemonic(@NotNull CWidgetId aWidgetId, @NotNull String aMnemonic) {
        this.addAttribute(aWidgetId, "mnemonic", aMnemonic);
    }

    public void setNoBorder(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "noBorder", true);
    }

    public void setOrientation(@NotNull CWidgetId aWidgetId, @NotNull EWidgetOrientation aOrientation) {
        CEventWidgetOrientation event = new CEventWidgetOrientation(aOrientation);
        CJsonObject json = event.toJson();
        this.addAttribute(aWidgetId, "orientation", json);
    }

    public void setPaintFocus(@NotNull CWidgetId aWidgetId, boolean aPaintFocus) {
        this.addAttribute(aWidgetId, "paintFocus", aPaintFocus);
    }

    public void setParent(@NotNull CWidgetId aWidgetId, @NotNull CWidgetId aParentId) {
        CEventWidgetId event = new CEventWidgetId(aParentId);
        this.addAttribute(aWidgetId, "parent", event.toJson());
    }

    public void setResetCells(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "resetCells", true);
    }

    public void setRolloverEnabled(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "rolloverEnabled", aEnabled);
    }

    public void setRowHeight(@NotNull CWidgetId aWidgetId, int aHeight) {
        CEventSetRowHeight event = new CEventSetRowHeight(null, aHeight);
        this.addAttribute(aWidgetId, "rowHeight", event.toJson());
    }

    public void setRowHeight(@NotNull CWidgetId aWidgetId, @NotNull String aRowId, int aHeight) {
        CEventSetRowHeight event = new CEventSetRowHeight(aRowId, aHeight);
        this.addAttribute(aWidgetId, "rowHeight", event.toJson());
    }

    public void setScrollOffset(@NotNull CWidgetId aWidgetId, int aScrollOffset) {
        this.addAttribute(aWidgetId, "scrollOffset", aScrollOffset);
    }

    public void setSelected(@NotNull CWidgetId aWidgetId, boolean aSelected) {
        this.addAttribute(aWidgetId, "selected", aSelected);
    }

    public void setSelectionBackground(@NotNull CWidgetId aWidgetId, @NotNull CEventColor aEvent) {
        this.addEvent(aWidgetId, "selectionBackground", (IRemoteSkinEvent)aEvent);
    }

    public void setSelectionForeground(@NotNull CWidgetId aWidgetId, @NotNull CEventColor aEvent) {
        this.addEvent(aWidgetId, "selectionForeground", (IRemoteSkinEvent)aEvent);
    }

    public void setSortable(@NotNull CWidgetId aWidgetId, boolean aSortable) {
        this.addAttribute(aWidgetId, "sortable", aSortable);
    }

    public void setStepSize(@NotNull CWidgetId aWidgetId, double aValue) {
        this.addAttribute(aWidgetId, "stepSizeDouble", aValue);
    }

    public void setStepSize(@NotNull CWidgetId aWidgetId, int aValue) {
        this.addAttribute(aWidgetId, "stepSizeInt", aValue);
    }

    public void setStrokeBorder(@NotNull CWidgetId aWidgetId, @NotNull CEventStrokeBorder aEvent) {
        this.addEvent(aWidgetId, "strokeBorder", (IRemoteSkinEvent)aEvent);
    }

    public void setTabProperties(@NotNull CWidgetId aWidgetId, @NotNull CEventTabProperties aEvent) {
        this.addEvent(aWidgetId, "tabProperties", (IRemoteSkinEvent)aEvent);
    }

    public void setTabSize(@NotNull CWidgetId aWidgetId, int aTabSize) {
        this.addAttribute(aWidgetId, "tabSize", aTabSize);
    }

    public void setTabTitle(@NotNull CWidgetId aWidgetId, @NotNull String aText) {
        this.addAttribute(aWidgetId, "tabTitle", aText);
    }

    public void setTableData(@NotNull CWidgetId aWidgetId, @NotNull CEventTableContent aTableContent) {
        this.addEvent(aWidgetId, "tableContent", (IRemoteSkinEvent)aTableContent);
    }

    public void setTableSelectionMode(@NotNull CWidgetId aWidgetId, boolean aCellSelectionEnabled, @NotNull ETableSelectionMode aColumnSelectionMode, @NotNull ETableSelectionMode aRowSelectionMode) {
        CEventTableSelectionMode event = new CEventTableSelectionMode(aCellSelectionEnabled, aColumnSelectionMode, aRowSelectionMode);
        this.addAttribute(aWidgetId, "tableSelectionMode", event.toJson());
    }

    public void setTableAutoResize(@NotNull CWidgetId aWidgetId, @NotNull ETableAutoResize aMode) {
        this.addAttribute(aWidgetId, "tableCell", aMode.name());
    }

    public void setTableCell(@NotNull CWidgetId aWidgetId, @NotNull CEventTableCell aEvent) {
        this.addAttribute(aWidgetId, "tableCell", aEvent.toJson());
    }

    public void setTableCellDefaultBackground(@NotNull CWidgetId aWidgetId, @NotNull CEventColor aEvent) {
        this.addAttribute(aWidgetId, "tableCellDefaultBackground", aEvent.toJson());
    }

    public void setTableCellDefaultForeground(@NotNull CWidgetId aWidgetId, @NotNull CEventColor aEvent) {
        this.addAttribute(aWidgetId, "tableCellDefaultForeground", aEvent.toJson());
    }

    public void setTableCellDefaultFont(@NotNull CWidgetId aWidgetId, @NotNull CEventFont aEvent) {
        this.addAttribute(aWidgetId, "tableCellDefaultFont", aEvent.toJson());
    }

    public void setTableCellDefaultBorder(@NotNull CWidgetId aWidgetId, @NotNull IBorder aBorder) {
        this.addAttribute(aWidgetId, "tableCellDefaultBorder", aBorder.toJson());
    }

    public void setTableGridColor(@NotNull CWidgetId aWidgetId, @NotNull Color aColor) {
        CEventColor event = new CEventColor(aColor);
        this.addAttribute(aWidgetId, "tableGridColor", event.toJson());
    }

    public void setTableHeader(@NotNull CWidgetId aWidgetId, @NotNull CEventTableHeader aEvent) {
        this.addAttribute(aWidgetId, "tableHeader", aEvent.toJson());
    }

    public void setTableHeaders(@NotNull CWidgetId aWidgetId, @NotNull CEventTableHeaders aEvent) {
        this.addAttribute(aWidgetId, "tableHeaders", aEvent.toJson());
    }

    public void setTableHeaderBackgroundColor(@NotNull CWidgetId aWidgetId, @NotNull String aColumnId, @NotNull Color aColor) {
        CEventTableHeader event = new CEventTableHeader(aColumnId);
        event.getLabelAttributes().setBackground(new CEventColor(aColor));
        this.addAttribute(aWidgetId, "tableHeader", event.toJson());
    }

    public void setTableHeaderForegroundColor(@NotNull CWidgetId aWidgetId, @NotNull String aColumnId, @NotNull Color aColor) {
        CEventTableHeader event = new CEventTableHeader(aColumnId);
        event.getLabelAttributes().setForeground(new CEventColor(aColor));
        this.addAttribute(aWidgetId, "tableHeader", event.toJson());
    }

    public void setTableHeaderIcon(@NotNull CWidgetId aWidgetId, @NotNull CEventIcon aIcon) {
        this.addAttribute(aWidgetId, "tableHeaderIcon", aIcon.toJson());
    }

    public void setTableHeaderTooltip(@NotNull CWidgetId aWidgetId, @NotNull String aColumnId, String aTooltip) {
        CEventTableHeader event = new CEventTableHeader(aColumnId);
        event.getLabelAttributes().setTooltip(aTooltip);
        this.addAttribute(aWidgetId, "tableHeader", event.toJson());
    }

    public void setTableInterCellSpacing(@NotNull CWidgetId aWidgetId, int aWidth, int aHeight) {
        CEventDimension event = new CEventDimension(aWidth, aHeight);
        this.addAttribute(aWidgetId, "tableInterCellSpacing", event.toJson());
    }

    public void setText(@NotNull CWidgetId aWidgetId, @NotNull String aText) {
        this.addAttribute(aWidgetId, "text", aText);
    }

    public void setText(@NotNull CWidgetId aWidgetId, @NotNull CEventText aEvent) {
        this.addEvent(aWidgetId, "text", (IRemoteSkinEvent)aEvent);
    }

    public void setTitle(@NotNull CWidgetId aWidgetId, @Nullable String aTitle) {
        this.addAttribute(aWidgetId, "title", aTitle == null ? "-?-" : aTitle);
    }

    public void setTitledBorder(@NotNull CWidgetId aWidgetId, @NotNull CEventTitledBorder aEvent) {
        this.addEvent(aWidgetId, "titledBorder", (IRemoteSkinEvent)aEvent);
    }

    public void setTreeSelectionMode(@NotNull CWidgetId aWidgetId, @NotNull ETreeSelectionMode aMode) {
        this.addAttribute(aWidgetId, "treeSelectionMode", new CEventTreeSelectionMode(aMode).toJson());
    }

    public void setTreeDefaultLeafIcon(@NotNull CWidgetId aWidgetId, @NotNull CEventIcon aEvent) {
        Object o = aEvent.toJson();
        this.addAttribute(aWidgetId, "treeDefaultLeafIcon", o);
    }

    public void setTreeDefaultOpenIcon(@NotNull CWidgetId aWidgetId, @NotNull CEventIcon aEvent) {
        Object o = aEvent.toJson();
        this.addAttribute(aWidgetId, "treeDefaultOpenIcon", o);
    }

    public void setTreeNodes(@NotNull CWidgetId aWidgetId, @NotNull CEventTreeNode aEvent) {
        Object o = aEvent.toJson();
        this.addAttribute(aWidgetId, "treeSetNodes", o);
    }

    public void setTreeRootVisible(@NotNull CWidgetId aWidgetId, boolean aVisible) {
        this.addAttribute(aWidgetId, "treeRootVisible", aVisible);
    }

    public void setTreeScrollsOnExpand(@NotNull CWidgetId aWidgetId, boolean aScroll) {
        this.addAttribute(aWidgetId, "treeScrollsOnExpand", aScroll);
    }

    public void setTreeShowLines(@NotNull CWidgetId aWidgetId, boolean aShowLines) {
        this.addAttribute(aWidgetId, "treeShowLines", aShowLines);
    }

    public void setTreeShowRootHandles(@NotNull CWidgetId aWidgetId, boolean aShowRootHandles) {
        this.addAttribute(aWidgetId, "treeShowRootHandles", aShowRootHandles);
    }

    public void setTreeToggleClickCount(@NotNull CWidgetId aWidgetId, int aClickCount) {
        this.addAttribute(aWidgetId, "treeToggleClickCount", aClickCount);
    }

    public void setValue(@NotNull CWidgetId aWidgetId, double aValue) {
        this.addAttribute(aWidgetId, "doubleValue", aValue);
    }

    public void setValue(@NotNull CWidgetId aWidgetId, int aValue) {
        this.addAttribute(aWidgetId, "valueInt", aValue);
    }

    public void setVerticalAlignment(@NotNull CWidgetId aWidgetId, @NotNull CEventVerticalAlignment aEvent) {
        this.addEvent(aWidgetId, "verticalAlignment", (IRemoteSkinEvent)aEvent);
    }

    public void setVerticalTextPosition(@NotNull CWidgetId aWidgetId, @NotNull CEventVerticalTextPosition aEvent) {
        this.addEvent(aWidgetId, "verticalTextPosition", (IRemoteSkinEvent)aEvent);
    }

    public void setVisible(@NotNull CWidgetId aWidgetId, boolean aVisible) {
        this.addAttribute(aWidgetId, "visible", aVisible);
    }

    public void setVisibleRowCount(@NotNull CWidgetId aWidgetId, int aVisibleRowCount) {
        this.addAttribute(aWidgetId, "visibleRowCount", aVisibleRowCount);
    }

    public void setWantChange(@NotNull CWidgetId aWidgetId, boolean aEnable) {
        this.addAttribute(aWidgetId, "wantChange", aEnable);
    }

    public void setWidthInCharacters(@NotNull CWidgetId aWidgetId, int aCount) {
        this.addAttribute(aWidgetId, "widthInCharacters", aCount);
    }

    public void showColorChooserDialog(@NotNull CWidgetId aWidgetId, @NotNull CEventShowColorChooserDialog aEvent) {
        this.addEvent(aWidgetId, "showColorChooserDialog", (IRemoteSkinEvent)aEvent);
    }

    public void showFileChooserDialog(@NotNull CWidgetId aWidgetId, @NotNull CEventShowFileChooserDialog aEvent) {
        this.addEvent(aWidgetId, "showFileChooserDialog", (IRemoteSkinEvent)aEvent);
    }

    public void showHorizontalTableLines(@NotNull CWidgetId aWidgetId, boolean aShow) {
        this.addAttribute(aWidgetId, "tableShowHorizontalLines", aShow);
    }

    public void showInputDialog(@NotNull CWidgetId aWidgetId, @NotNull CEventShowInputDialog aEvent) {
        this.addEvent(aWidgetId, "showStringInputDialog", (IRemoteSkinEvent)aEvent);
    }

    public void showMessageDialog(@NotNull CWidgetId aWidgetId, @NotNull CEventShowMessageDialog aEvent) {
        this.addEvent(aWidgetId, "showMsgDialog", (IRemoteSkinEvent)aEvent);
    }

    public void showPopupMenu(@NotNull CWidgetId aWidgetId, boolean aShow) {
        this.addAttribute(aWidgetId, "popupVisible", aShow);
    }

    public void showText(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "showText", aEnabled);
    }

    public void showSelectDialog(@NotNull CWidgetId aWidgetId, @NotNull CEventShowSelectDialog aEvent) {
        this.addEvent(aWidgetId, "showSelectDialog", (IRemoteSkinEvent)aEvent);
    }

    public void showVerticalTableLines(@NotNull CWidgetId aWidgetId, boolean aShow) {
        this.addAttribute(aWidgetId, "tableShowVerticalLines", aShow);
    }

    public void sizeColumnFitToWidth(@NotNull CWidgetId aWidgetId, @NotNull String aColumnId, boolean aFit) {
        CEventTableColumn event = new CEventTableColumn(aColumnId);
        event.setWidthToFit(aFit);
        this.addAttribute(aWidgetId, "sizeColumnWidthToFit", event.toJson());
    }

    public void startEditing(@NotNull CWidgetId aWidgetId, @NotNull String aItemId) {
        this.addAttribute(aWidgetId, "startEditing", aItemId);
    }

    public void stopEditing(@NotNull CWidgetId aWidgetId) {
        this.addAttribute(aWidgetId, "stopEditing", true);
    }

    public void unmount(@NotNull CWidgetId aWidgetId) {
        CEventUnmountWidget ev = new CEventUnmountWidget(aWidgetId, 0);
        Object jo = ev.toJson();
        this.addAttribute(CModelConstants.CONTEXT_WIDGET_ID, "unmount", jo);
    }

    public void updateComboBox(@NotNull CWidgetId aWidgetId, @NotNull CEventUpdateComboBox aEvent) {
        this.addEvent(aWidgetId, "update", (IRemoteSkinEvent)aEvent);
    }

    public void wantCaretNotification(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "wantCaretChange", aEnabled);
    }

    public void wantChangeNotification(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "wantChange", aEnabled);
    }

    public void wantOnEnterNotification(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "wantValueOnEnter", aEnabled);
    }

    private void addAttribute(@NotNull CWidgetId aWidgetId, @NotNull String aKey, @Nullable Object aValue) {
        if (this.mSender != null) {
            if (aValue != null) {
                this.mSender.addAttribute(aWidgetId, aKey, aValue);
            }
        } else {
            LOG.error("No Sender in CServerWidgets {}", new Object[]{aWidgetId});
        }
    }

    public void setSender(IJsonCommandSender aSender) {
        this.mSender = aSender;
    }

    public void useTreeSingleNodeRenderer(@NotNull CWidgetId aWidgetId, boolean aEnabled) {
        this.addAttribute(aWidgetId, "treeSingleNodeRenderer", aEnabled);
    }

    void applyWidgetNotification(CWidgetId aWidgetId, String aKey, Object aValue) {
        try {
            this.mListeners.applyNotification(aWidgetId, aKey, aValue);
        }
        catch (Throwable aE) {
            LOG.error(aE, "Error applying notification {} to {}", new Object[]{aKey, aWidgetId});
        }
    }

    public void addEvent(@NotNull CWidgetId aWidgetId, @NotNull String aEventId, @NotNull IRemoteSkinEvent aEvent) {
        this.addAttribute(aWidgetId, aEventId, aEvent.toJson());
    }

    public void deactivate() {
        this.mListeners.deactivate();
        this.mSender.deactivate();
    }
}

