/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordFileStoreNotifyFileDownloaded
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"b39ebcec-07f7-4442-a448-6cf6229bbcf2");
    public static final String NAME = "FileStoreNotifyFileDownloaded";
    public static final String DESCRIPTION = "Notification: A file has been downloaded and saved into the indexed directory.";
    public static final String SLOT_BYTES = "4";
    public static final String SLOT_FILE = "5";
    public static final String SLOT_FILE_ENTRY = "3";
    public static final String SLOT_HASH = "2";
    public static final String SLOT_PATH = "1";
    public static final String SLOT_RESULT_CODE = "6";
    public static final String SLOT_RESULT_TEXT = "7";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static byte[] getBytes(@NotNull CRecord aRecord, byte[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_BYTES);
        if (slot == null) {
            return aDefault;
        }
        return (byte[])slot.getValue();
    }

    public static Object getFile(@NotNull CRecord aRecord, Object aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILE);
        if (slot == null) {
            return aDefault;
        }
        return slot.getValue();
    }

    public static CRecord getFileEntry(@NotNull CRecord aRecord, CRecord aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILE_ENTRY);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord)slot.getValue();
    }

    public static String getHash(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_HASH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getPath(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PATH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static int getResultCode(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_RESULT_CODE);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static String getResultText(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_RESULT_TEXT);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setBytes(@NotNull CRecord aRecord, byte[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BYTE_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_BYTES, slot);
    }

    public static void setFile(@NotNull CRecord aRecord, Object aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.OBJECT, (Object)aValue);
        aRecord.addSlot(SLOT_FILE, slot);
    }

    public static void setFileEntry(@NotNull CRecord aRecord, CRecord aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD, (Object)aValue);
        aRecord.addSlot(SLOT_FILE_ENTRY, slot);
    }

    public static void setHash(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_HASH, slot);
    }

    public static void setPath(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PATH, slot);
    }

    public static void setResultCode(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_RESULT_CODE, slot);
    }

    public static void setResultText(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_RESULT_TEXT, slot);
    }
}

