/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.file.store.common;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreFile;
import de.sillysky.nyssr.impl.file.store.records.CRecordFileStoreGetChunk;
import de.sillysky.nyssr.impl.file.store.service.IFileStore;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilFile;
import de.sillysky.nyssr.util.hash.CMd5;
import de.sillysky.nyssr.util.hash.CUtilMd5;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilFileStore {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilFileStore.class);

    private CUtilFileStore() {
    }

    @NotNull
    public static CRecord createRecordGetChunk(@NotNull String aHash, long aFileLength, long aWritePosition, int aChunkSize) throws CException {
        CRecord record = CRecordFileStoreGetChunk.create();
        CRecordFileStoreGetChunk.setHash(record, aHash);
        int size = (int)Math.min((long)aChunkSize, aFileLength - aWritePosition);
        CRecordFileStoreGetChunk.setChunkLength(record, size);
        CRecordFileStoreGetChunk.setChunkPosition(record, aWritePosition);
        return record;
    }

    @Nullable
    public static String calcHash(@NotNull File aFile) {
        String result = null;
        CMd5 md5 = CUtilMd5.calculate((File)aFile, null);
        if (md5 != null) {
            result = md5.toBase32();
        }
        return result;
    }

    @NotNull
    public static CRecord fileToRecord(String aHash, String aPath, long aLength, Instant aTimeOfCreation, Instant aTimeOfLastModification) throws CException {
        CRecord record = CRecordFileStoreFile.create();
        return CUtilFileStore.fileToRecord(record, aHash, aPath, aLength, aTimeOfCreation, aTimeOfLastModification);
    }

    @NotNull
    public static CRecord fileToRecord(@NotNull CRecord aRecord, @NotNull String aHash, @NotNull String aPath, long aLength, @NotNull Instant aTimeOfCreation, @NotNull Instant aTimeOfLastModification) throws CException {
        CRecordFileStoreFile.setHash((CRecord)aRecord, (String)aHash);
        CRecordFileStoreFile.setPath((CRecord)aRecord, (String)aPath);
        CRecordFileStoreFile.setFileLength((CRecord)aRecord, (long)aLength);
        CRecordFileStoreFile.setTimeOfCreation((CRecord)aRecord, (Instant)aTimeOfCreation);
        CRecordFileStoreFile.setTimeOfLastModification((CRecord)aRecord, (Instant)aTimeOfLastModification);
        return aRecord;
    }

    public static File rename(@NotNull IFileStore mFileStore, @NotNull File aFile, @NotNull String aRelativePath, @NotNull String aHash, @NotNull FileTime aTimeOfCreation, @NotNull FileTime aTimeOfLastModification) {
        Path basePath = mFileStore.getDirectoryForIndexedFiles();
        if (aFile.exists() && basePath != null) {
            File destFile = CUtilFileStore.getFile(basePath, aRelativePath, false, aHash);
            File destDir = destFile.getParentFile();
            if (!CUtilFile.createDirectories((File)destDir)) {
                return null;
            }
            try {
                Files.move(aFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                CUtilFile.setCreationTime((File)destFile, (FileTime)aTimeOfCreation);
                CUtilFile.setLastModifiedTime((File)destFile, (FileTime)aTimeOfLastModification);
                return destFile;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public static File getFile(@NotNull Path aBasePath, @NotNull String aRelativePath, boolean aIsTempFile, @Nullable String aHash) {
        if (aIsTempFile) {
            return aBasePath.resolve(aRelativePath + ".part").toFile();
        }
        if (CUtilString.isEmpty((String)aHash)) {
            return aBasePath.resolve(aRelativePath).toFile();
        }
        return aBasePath.resolve(aRelativePath + "._32_" + aHash).toFile();
    }
}

