/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing;

import de.sillysky.nyssr.util.swing.icon.CIconHelper;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jetbrains.annotations.NotNull;

public class CFrame {
    private CFrame() {
    }

    public static void initialize(JFrame aFrame) {
        ImageIcon icon = CIconHelper.loadFromJar(CFrame.class, "images/sd 16x16x256.png", "sillysky");
        if (icon != null) {
            aFrame.setIconImage(icon.getImage());
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Insets insets = toolkit.getScreenInsets(aFrame.getGraphicsConfiguration());
        int x = insets.left;
        int y = insets.top;
        int width = screenSize.width - x - insets.right;
        int height = screenSize.height - y - insets.bottom;
        aFrame.setBounds(x, y, width, height);
        aFrame.setExtendedState(aFrame.getExtendedState() | 6);
    }

    public static void setLookAndFeel(@NotNull String aLookAndFeel) {
        try {
            UIManager.setLookAndFeel(aLookAndFeel);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
    }
}

