/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.hash.CUtilBase32;
import de.sillysky.nyssr.util.hash.CUtilMd5;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CMd5 {
    private static final int LENGTH_IN_BITS = 128;
    private static final int LENGTH_IN_BYTES = 16;
    public static final CMd5 EMPTY = CMd5.create();
    private final byte[] mDigest;

    private CMd5(byte[] aDigest) {
        this.mDigest = aDigest;
    }

    public static CMd5 create() {
        byte[] bb = CUtilByteArray.createFilled(16, (byte)0);
        return new CMd5(bb);
    }

    public static CMd5 create(byte[] aDigest) {
        CUtilCheck.checkNotNull(aDigest, "Hash is null.", new Object[0]);
        CUtilCheck.checkTrue(aDigest.length == 16, "Hash has wrong length.", new Object[0]);
        if (CUtilMd5.isValid(aDigest)) {
            return new CMd5(aDigest);
        }
        return null;
    }

    public static CMd5 createByData(byte[] aData) {
        return CUtilMd5.calculate(aData);
    }

    public static CMd5 createByData(byte[] aData, byte[] aSalt) {
        return CUtilMd5.calculate(aData, aSalt);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CMd5 createByBase64(String aBase64) {
        return new CMd5(CUtilMd5.fromBase64(aBase64));
    }

    public static CMd5 createByBase32(String aBase32) {
        byte[] decoded = CUtilBase32.decode(aBase32);
        return new CMd5(decoded);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CMd5 fromStream(@NotNull DataInput aStream) throws IOException {
        byte[] digest = new byte[16];
        aStream.readFully(digest);
        return new CMd5(digest);
    }

    public static int getStreamedLength() {
        return 16;
    }

    public static String getString(byte[] aDigest) {
        return CUtilMd5.getString(aDigest);
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CMd5 other = (CMd5)aObj;
        return Arrays.equals(this.mDigest, other.mDigest);
    }

    public byte[] getDigest() {
        return (byte[])this.mDigest.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mDigest);
        return result;
    }

    public boolean isValid() {
        for (byte b : this.mDigest) {
            if (b == 0) continue;
            return true;
        }
        return false;
    }

    public String toBase64() {
        return CUtilMd5.toBase64(this.mDigest);
    }

    public String toBase32() {
        return CUtilBase32.encode(this.mDigest);
    }

    public void toStream(@NotNull DataOutput aStream) throws IOException {
        aStream.write(this.mDigest);
    }

    public String toString() {
        return CMd5.getString(this.mDigest);
    }
}

