/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CPathComponents;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRelativePath {
    private final String mPath;
    private final String mName;
    private final int mVersion;
    private final String mExtension;

    public CRelativePath(@NotNull String aPath, @NotNull String aName, int aVersion, @NotNull String aExtension) {
        this.mPath = this.checkPath(aPath);
        this.mName = aName;
        this.mVersion = aVersion;
        this.mExtension = aExtension;
    }

    public CRelativePath(@NotNull String aCombinedPath) {
        CPathComponents pc = new CPathComponents(aCombinedPath);
        Path pp = pc.getPath();
        this.mPath = pp == null ? "" : this.checkPath(pp.toString());
        String name = pc.getName();
        int pos = name.lastIndexOf(45);
        if (pos >= 0) {
            this.mName = name.substring(0, pos);
            this.mVersion = CUtilInteger.fromString(name.substring(pos + 1), 0);
        } else {
            this.mName = name;
            this.mVersion = 0;
        }
        this.mExtension = pc.getExt();
    }

    private String checkPath(@NotNull String aPath) {
        String p = aPath.replace('\\', '/');
        return CUtilString.removeLastChar(p, '/');
    }

    @NotNull
    public String getPath() {
        return this.mPath;
    }

    @NotNull
    public String getName() {
        return this.mName;
    }

    public int getVersion() {
        return this.mVersion;
    }

    @NotNull
    public String getExtension() {
        return this.mExtension;
    }

    public boolean equals(@Nullable Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CRelativePath that = (CRelativePath)aOther;
        return this.mVersion == that.mVersion && this.mPath.equals(that.mPath) && this.mName.equals(that.mName) && this.mExtension.equals(that.mExtension);
    }

    public int hashCode() {
        return Objects.hash(this.mPath, this.mName, this.mVersion, this.mExtension);
    }

    public String toString() {
        return this.mPath + this.mName + '-' + this.mVersion + this.mExtension;
    }
}

