/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;

public final class CFileReader {
    private CFileReader() {
    }

    public static byte[] readAllBytes(File aFile) throws IOException {
        return Files.readAllBytes(aFile.toPath());
    }

    public static byte[] readAllBytes(Path aPath) throws IOException {
        return Files.readAllBytes(aPath);
    }

    public static byte[] readByteArrayFully(FileChannel aFc, long aPos, int aLength) throws IOException {
        if (aPos >= 0L) {
            aFc.position(aPos);
        }
        int bytesInMemory = 0;
        int bytesLeft = aLength;
        byte[] result = new byte[aLength];
        while (bytesInMemory < aLength) {
            ByteBuffer bufRead = ByteBuffer.allocate(bytesLeft);
            int bytesRead = aFc.read(bufRead);
            if (bytesRead == -1) {
                return null;
            }
            bufRead.rewind();
            bufRead.get(result, bytesInMemory, bytesRead);
            bytesInMemory += bytesRead;
            bytesLeft -= bytesRead;
        }
        return result;
    }

    public static byte[] readByteArray(FileChannel aFc, long aPos, int aLength) throws IOException {
        ByteBuffer bufRead;
        int bytesRead;
        if (aPos >= 0L) {
            aFc.position(aPos);
        }
        if ((bytesRead = aFc.read(bufRead = ByteBuffer.allocate(aLength))) < 0) {
            return null;
        }
        bufRead.rewind();
        byte[] result = new byte[bytesRead];
        bufRead.get(result, 0, bytesRead);
        return result;
    }
}

