/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilDouble;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.array.CUtilArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilDoubleArray {
    public static final double[] EMPTY = new double[0];

    private CUtilDoubleArray() {
    }

    public static double @Nullable [] copy(double @Nullable [] aValue) {
        if (aValue == null) {
            return null;
        }
        if (aValue.length == 0) {
            return EMPTY;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    public static double @NotNull [] fromList(@Nullable List<?> aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return EMPTY;
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (Object element : aValue) {
            double[] dArray;
            if (element == null) continue;
            if (element instanceof Double) {
                list.add((Double)element);
                continue;
            }
            if (element instanceof Double[]) {
                Double[] dd2 = (Double[])element;
                list.addAll(Arrays.asList(dd2));
                continue;
            }
            if (element instanceof double[]) {
                double[] dd;
                for (double d : dd = (double[])element) {
                    list.add(d);
                }
                continue;
            }
            if (!(element instanceof String)) continue;
            String s = (String)element;
            for (double d : dArray = CUtilDoubleArray.fromString(s)) {
                list.add(d);
            }
        }
        double[] arr = new double[list.size()];
        int pos = 0;
        for (Double d : list) {
            arr[pos] = d;
            ++pos;
        }
        return arr;
    }

    public static double @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        double[] value = new double[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            value[i] = aStream.readDouble();
        }
        return value;
    }

    public static double @NotNull [] random(int aLength) {
        double[] array = new double[aLength];
        for (int i = 0; i < aLength; ++i) {
            array[i] = CUtilRandom.getRandom().nextDouble();
        }
        return array;
    }

    public static double @NotNull [] fromString(@Nullable String aValue) {
        return CUtilDoubleArray.fromString(aValue, ",");
    }

    public static double @NotNull [] fromString(@Nullable String aValue, @NotNull String aDelimiter) {
        double[] arr;
        if (aValue == null || aValue.isEmpty()) {
            arr = new double[]{};
        } else {
            String[] tokens = aValue.split(aDelimiter, -1);
            arr = new double[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                arr[i] = CUtilDouble.fromString(tokens[i]);
            }
        }
        return arr;
    }

    public static boolean isEqual(double @Nullable [] aValue1, double @Nullable [] aValue2) {
        return Arrays.equals(aValue1, aValue2);
    }

    @NotNull
    public static String toString(double @Nullable [] aValue, char aDelimiter, int aMaxLen) {
        if (aValue == null) {
            return "null";
        }
        return CUtilArray.toString(0, aDelimiter, aMaxLen, index -> index >= aValue.length ? "\uf00bE" : CUtilDouble.toString(aValue[index]));
    }

    public static void toStream(@NotNull DataOutput aStream, double @Nullable [] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (double element : aValue) {
                aStream.writeDouble(element);
            }
        }
    }
}

