/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.nanoservice.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordOfANanoService
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("2df12b34-7fa1-4907-9f65-6edddb07bec0");
    public static final String NAME = "OfANanoService";
    public static final String DESCRIPTION = "All data belonging to a nano service.";
    public static final String SLOT_NAME = "name";
    public static final String SLOT_NID = "nid";
    public static final String SLOT_OBSERVER = "obs";
    public static final String SLOT_SID = "sid";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static IId getNid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CTargetAddress[] getObserver(@NotNull CRecord aRecord, CTargetAddress[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_OBSERVER);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress[])slot.getValue();
    }

    public static IId getSid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static void setName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_NAME, slot);
    }

    public static void setNid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_NID, slot);
    }

    public static void setObserver(@NotNull CRecord aRecord, CTargetAddress[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS_ARRAY, aValue);
        aRecord.addSlot(SLOT_OBSERVER, slot);
    }

    public static void setSid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_SID, slot);
    }
}

