/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.target.registry;

import de.sillysky.nyssr.address.CNamespaceAddress;
import de.sillysky.nyssr.impl.target.registry.CTargetRegistry;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.logger.IMessageLoggerFactory;
import de.sillysky.nyssr.message.queue.IMessageQueueRegistry;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.IRecordRegistryHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.ITargetRegistryFactory;
import org.jetbrains.annotations.NotNull;

public final class CTargetRegistryFactory
implements ITargetRegistryFactory,
IService {
    private IMessageLoggerFactory mMessageLoggerFactory;
    private IListenerRegistry mListenerRegistry;
    private IMessageSender mMessageSender;

    public static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IMessageSender.class);
        aDependencyList.add(IMessageLoggerFactory.class);
        aDependencyList.add(IListenerRegistry.class);
        aDependencyList.add(IRecordRegistryHelper.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mMessageLoggerFactory = aServiceRegistry.getService(IMessageLoggerFactory.class);
        this.mListenerRegistry = aServiceRegistry.getService(IListenerRegistry.class);
        this.mMessageSender = aServiceRegistry.getService(IMessageSender.class);
        aServiceRegistry.registerService(ITargetRegistryFactory.class, this);
    }

    @Override
    @NotNull
    public ITargetRegistry createTargetRegistry(@NotNull INamespace aNamespace, @NotNull CNamespaceAddress aNamespaceAddress, @NotNull IMessageQueueRegistry aMessageQueueRegistry) {
        CTargetRegistry tr = new CTargetRegistry();
        tr.activate(aNamespace, aMessageQueueRegistry, this.mMessageSender, this.mMessageLoggerFactory, this.mListenerRegistry);
        return tr;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }
}

