/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CUtilNodeAddressArray;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotNodeAddressArray
implements ISlot,
ISingleSlotTypeFactory {
    private final CNodeAddress[] mValue;

    CSlotNodeAddressArray() {
        this.mValue = null;
    }

    private CSlotNodeAddressArray(CNodeAddress[] aValue) {
        this.mValue = CUtilNodeAddressArray.copy(aValue);
    }

    @NotNull
    private static CSlotNodeAddressArray create(@Nullable Object aValue) {
        if (aValue instanceof CNodeAddress[]) {
            return new CSlotNodeAddressArray((CNodeAddress[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotNodeAddressArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotNodeAddressArray.fromList((List)aValue);
        }
        return new CSlotNodeAddressArray();
    }

    @NotNull
    private static CSlotNodeAddressArray fromList(@NotNull List<?> aValue) {
        if (aValue.isEmpty()) {
            return new CSlotNodeAddressArray();
        }
        ArrayList<CNodeAddress> list = new ArrayList<CNodeAddress>();
        for (Object element : aValue) {
            if (element == null) continue;
            if (element instanceof CNodeAddress) {
                CNodeAddress e = (CNodeAddress)element;
                list.add(e);
                continue;
            }
            if (element instanceof CNodeAddress[]) {
                CNodeAddress[] ee = (CNodeAddress[])element;
                list.addAll(Arrays.asList(ee));
                continue;
            }
            if (!(element instanceof String)) continue;
            String s = (String)element;
            CNodeAddress ta = CNodeAddress.fromString(s);
            list.add(ta);
        }
        CNodeAddress[] arr = new CNodeAddress[list.size()];
        int pos = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CNodeAddress element;
            arr[pos] = element = (CNodeAddress)iterator.next();
            ++pos;
        }
        return new CSlotNodeAddressArray(arr);
    }

    @NotNull
    private static CSlotNodeAddressArray fromStream(@NotNull DataInput aStream) throws IOException {
        CNodeAddress[] value = CUtilNodeAddressArray.fromStream(aStream);
        return new CSlotNodeAddressArray(value);
    }

    @NotNull
    private static CSlotNodeAddressArray fromString(@NotNull String aValue) {
        CNodeAddress[] value = CUtilNodeAddressArray.fromString(aValue);
        return new CSlotNodeAddressArray(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotNodeAddressArray.create(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            CNodeAddress[] values = new CNodeAddress[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                if (child instanceof String && CUtilString.isValid((String)child)) {
                    values[i++] = CNodeAddress.fromString((String)child);
                    continue;
                }
                values[i++] = null;
            }
            return new CSlotNodeAddressArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotNodeAddressArray other = (CSlotNodeAddressArray)aObj;
        return Arrays.equals(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return CNodeAddress[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return new CSlotNodeAddressArray(this.mValue);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.NODE_ADDRESS_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof CNodeAddress[]) {
            Object[] bb = (CNodeAddress[])aValue;
            return Arrays.equals(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotNodeAddressArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilNodeAddressArray.toStream(aStream, this.mValue);
    }

    public String toString() {
        return CUtilNodeAddressArray.toString(this.mValue);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilNodeAddressArray.valueToString(this.mValue);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (CNodeAddress v : this.mValue) {
                arr.add(v == null ? "" : v.valueToString());
            }
            return arr;
        }
        return null;
    }
}

