/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilObjectArray;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotIdArray
implements ISlot,
ISingleSlotTypeFactory {
    private final IId[] mValue;

    CSlotIdArray() {
        this.mValue = null;
    }

    private CSlotIdArray(@Nullable IId[] aValue) {
        this.mValue = CIdFactory.copy(aValue);
    }

    @NotNull
    private static CSlotIdArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof IId[]) {
            return new CSlotIdArray((IId[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotIdArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotIdArray.fromList((List)aValue);
        }
        return new CSlotIdArray();
    }

    @NotNull
    private static CSlotIdArray fromList(@NotNull List<?> aList) {
        IId[] array = CIdFactory.createArrayFromList(aList);
        return new CSlotIdArray(array);
    }

    @NotNull
    private static CSlotIdArray fromStream(@NotNull DataInput aStream) throws IOException {
        IId[] array = CIdFactory.arrayFromStream(aStream);
        return new CSlotIdArray(array);
    }

    @NotNull
    private static CSlotIdArray fromString(@NotNull String aString) {
        IId[] array = CIdFactory.arrayFromString(aString);
        return new CSlotIdArray(array);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotIdArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            IId[] values = new IId[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                if (child instanceof String && CUtilString.isValid((String)child)) {
                    String s = (String)child;
                    values[i] = CIdFactory.fromObject(s);
                } else {
                    values[i] = null;
                }
                ++i;
            }
            return new CSlotIdArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotIdArray other = (CSlotIdArray)aObj;
        return CIdFactory.isArrayEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return IId[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        IId[] value = CIdFactory.copy(this.mValue);
        return new CSlotIdArray(value);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.ID_ARRAY;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof IId[]) {
            IId[] bb = (IId[])aValue;
            return CIdFactory.isArrayEqual(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotIdArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CIdFactory.arrayToStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilObjectArray.toString((Object[])this.mValue, 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CIdFactory.writeArrayToString(this.mValue);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (IId id : this.mValue) {
                arr.add(id == null ? "" : id.valueToString());
            }
            return arr;
        }
        return null;
    }
}

