/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilBoolean;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotBoolean
implements ISlot,
ISingleSlotTypeFactory {
    @NotNull
    private final Boolean mValue;

    CSlotBoolean() {
        this.mValue = Boolean.FALSE;
    }

    private CSlotBoolean(boolean aValue) {
        this.mValue = aValue;
    }

    @NotNull
    private static CSlotBoolean fromObject(@Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            return new CSlotBoolean((Boolean)aValue);
        }
        if (aValue instanceof String) {
            return CSlotBoolean.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotBoolean.fromList((List)aValue);
        }
        return new CSlotBoolean();
    }

    @NotNull
    private static CSlotBoolean fromList(@NotNull List<?> aValue) {
        CSlotBoolean result;
        if (aValue.isEmpty()) {
            result = new CSlotBoolean();
        } else {
            Object object = aValue.get(0);
            result = CSlotBoolean.fromObject(object);
        }
        return result;
    }

    @NotNull
    private static CSlotBoolean fromStream(@NotNull DataInput aStream) throws IOException {
        boolean value = aStream.readBoolean();
        return new CSlotBoolean(value);
    }

    @NotNull
    private static CSlotBoolean fromString(@NotNull String aValue) {
        boolean value = CUtilBoolean.fromString(aValue);
        return new CSlotBoolean(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotBoolean.fromObject(aValue);
        }
        return null;
    }

    @Override
    @NotNull
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        boolean b = CUtilBoolean.fromObject(aValue, false);
        return new CSlotBoolean(b);
    }

    @Override
    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotBoolean other = (CSlotBoolean)aObj;
        return this.mValue == other.mValue;
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Boolean.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.BOOLEAN;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return this.mValue.hashCode();
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return this.mValue.equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotBoolean.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        aStream.writeBoolean(this.mValue);
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return Boolean.toString(this.mValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String valueToString() {
        return Boolean.toString(this.mValue);
    }

    @Override
    @NotNull
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return this.mValue;
    }
}

