/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.service;

import de.sillysky.nyssr.impl.service.CServiceDependencyList;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

final class CServiceStarter {
    @NotNull
    private final IServiceStarter mStarter;
    @NotNull
    private final CServiceDependencyList mDependencies;

    CServiceStarter(@NotNull IServiceStarter aServiceStarter, @NotNull CServiceDependencyList aDependencies) {
        this.mStarter = aServiceStarter;
        this.mDependencies = aDependencies;
    }

    @NotNull
    CServiceDependencyList getDependencies() {
        return this.mDependencies;
    }

    @NotNull
    String getName() {
        return this.mStarter.getClass().getName();
    }

    @NotNull
    IServiceStarter getServiceStarter() {
        return this.mStarter;
    }

    void start(@NotNull CServiceRegistry aRegistry) throws Exception {
        this.mStarter.start(aRegistry);
    }

    @NotNull
    public String toString() {
        return this.mStarter.getClass().getName() + '{' + this.mDependencies + '}';
    }
}

