/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.preferences;

import de.sillysky.nyssr.impl.preferences.CBackingStoreException;
import de.sillysky.nyssr.impl.preferences.CPreferences;
import de.sillysky.nyssr.impl.preferences.CPreferencesDescription;
import de.sillysky.nyssr.impl.preferences.IBackingStoreManager;
import de.sillysky.nyssr.preferences.IPreferenceService;
import de.sillysky.nyssr.preferences.IPreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CPreferencesService
implements IPreferenceService {
    private final Map<String, CPreferences> mTrees = new HashMap<String, CPreferences>();
    private final String mOwnerID;
    private final IBackingStoreManager mStoreManager;
    private CPreferences mSystemTree;

    CPreferencesService(IBackingStoreManager aStoreManager, String aOwnerID) {
        this.mOwnerID = aOwnerID;
        this.mStoreManager = aStoreManager;
        try {
            CPreferences[] prefs;
            for (CPreferences pref : prefs = this.mStoreManager.getStore().loadAll(this.mStoreManager, this.mOwnerID)) {
                if (pref.getDescription().getUserID() == null) {
                    this.mSystemTree = pref;
                    continue;
                }
                this.mTrees.put(pref.getDescription().getUserID(), pref);
            }
        }
        catch (CBackingStoreException cBackingStoreException) {
            // empty catch block
        }
    }

    protected List<CPreferences> getAllPreferences() {
        ArrayList<CPreferences> list = new ArrayList<CPreferences>();
        if (this.mSystemTree != null) {
            list.add(this.mSystemTree);
        }
        list.addAll(this.mTrees.values());
        return list;
    }

    @Override
    public synchronized IPreferences getSystemPreferences() {
        if (this.mSystemTree == null) {
            this.mSystemTree = new CPreferences(new CPreferencesDescription(this.mOwnerID, null), this.mStoreManager);
        }
        try {
            this.mSystemTree.sync();
        }
        catch (CBackingStoreException cBackingStoreException) {
            // empty catch block
        }
        return this.mSystemTree;
    }

    @Override
    public synchronized IPreferences getUserPreferences(String aName) {
        CPreferences result = this.mTrees.get(aName);
        if (result == null || !result.isValid()) {
            result = new CPreferences(new CPreferencesDescription(this.mOwnerID, aName), this.mStoreManager);
            this.mTrees.put(aName, result);
        }
        try {
            result.sync();
        }
        catch (CBackingStoreException cBackingStoreException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public synchronized String[] getUsers() {
        Set<String> userKeys = this.mTrees.keySet();
        return userKeys.toArray(new String[0]);
    }
}

