/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.nanoservice.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceAddObserver;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceAddObservers;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceDeregisterService;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceGetServiceInfo;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceMonitorAddFilter;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceMonitorRemoveAllFilter;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceMonitorRemoveFilter;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceRegisterService;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceRegisterServiceAndObserver;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceRemoveObserver;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceRemoveObservers;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceTriggerRecall;
import de.sillysky.nyssr.nanoservice.records.CRecordNanoServiceUpdateServices;
import de.sillysky.nyssr.nanoservice.records.CRecordOfANanoService;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

final class CTargetForNanoServiceRegistry
extends CTarget
implements IService {
    private static final String FILTER = "nid=SYSTEM";
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForNanoServiceRegistry.class);
    private INanoServiceRegistry mMyNanoServiceRegistry;
    private INamespaceRegistry mNamespaceRegistry;

    CTargetForNanoServiceRegistry() {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNanoServiceRegisterService.ID, this::asyncRegisterService);
        this.addMessageHandler(CRecordNanoServiceRegisterServiceAndObserver.ID, this::asyncRegisterServiceAndObserver);
        this.addMessageHandler(CRecordNanoServiceAddObserver.ID, this::asyncAddObserver);
        this.addMessageHandler(CRecordNanoServiceAddObservers.ID, this::asyncAddObservers);
        this.addMessageHandler(CRecordNanoServiceRemoveObserver.ID, this::asyncRemoveObserver);
        this.addMessageHandler(CRecordNanoServiceRemoveObservers.ID, this::asyncRemoveObservers);
        this.addMessageHandler(CRecordNanoServiceDeregisterService.ID, this::asyncDeregisterService);
        this.addMessageHandler(CRecordNanoServiceGetServiceInfo.ID, this::asyncGetServiceInfo);
        this.addMessageHandler(CRecordNanoServiceTriggerRecall.ID, this::asyncTriggerRecall);
        this.addMessageHandler(CRecordNanoServiceUpdateServices.ID, this::asyncUpdateServices);
        this.addMessageHandler(CRecordNanoServiceMonitorAddFilter.ID, this::asyncMonitorAddFilter);
        this.addMessageHandler(CRecordNanoServiceMonitorRemoveFilter.ID, this::asyncMonitorRemoveFilter);
        this.addMessageHandler(CRecordNanoServiceMonitorRemoveAllFilter.ID, this::asyncMonitorRemoveAllFilter);
    }

    public static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(ITargetRegistry.class, FILTER);
        aDependencyList.add(INanoServiceRegistry.class, FILTER);
        aDependencyList.add(INamespaceRegistry.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        LOG.debug("Activate {} {}", this.getClass().getSimpleName(), System.identityHashCode(this));
        this.mMyNanoServiceRegistry = aServiceRegistry.getService(INanoServiceRegistry.class, FILTER);
        this.mNamespaceRegistry = aServiceRegistry.getService(INamespaceRegistry.class);
        ITargetRegistry tr = aServiceRegistry.getService(ITargetRegistry.class, FILTER);
        assert (tr != null);
        tr.registerTarget(this, CWellKnownTID.NANO_SERVICE_REGISTRY);
    }

    private boolean asyncAddObserver(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        IId nid = CRecordNanoServiceAddObserver.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        IId sid = CRecordNanoServiceAddObserver.getSid(aRecord, null);
        CUtilCheck.checkNotNull(sid, "Missing Service ID", new Object[0]);
        CTargetAddress address = CRecordNanoServiceAddObserver.getObserver(aRecord, null);
        CUtilCheck.checkNotNull(address, "Missing Observer Address", new Object[0]);
        namespace.getNanoServiceRegistry().addObserver(sid, address, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddObservers(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        IId nid = CRecordNanoServiceAddObservers.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        IId[] sid = CRecordNanoServiceAddObservers.getSidArray(aRecord, null);
        CUtilCheck.checkNotNull(sid, "Missing Service IDs", new Object[0]);
        CTargetAddress address = CRecordNanoServiceAddObservers.getObserver(aRecord, null);
        CUtilCheck.checkNotNull(address, "Missing Observer Address", new Object[0]);
        namespace.getNanoServiceRegistry().addObservers(sid, address);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDeregisterService(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        IId nid = CRecordNanoServiceAddObservers.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        IId sid = CRecordNanoServiceDeregisterService.getSid(aRecord, null);
        CUtilCheck.checkNotNull(sid, "Missing Service ID", new Object[0]);
        namespace.getNanoServiceRegistry().removeNanoService(sid);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetServiceInfo(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        IId nid = CRecordNanoServiceAddObservers.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        IId sid = CRecordNanoServiceGetServiceInfo.getSid(aRecord, null);
        CUtilCheck.checkNotNull(sid, "Missing Service ID", new Object[0]);
        namespace.getNanoServiceRegistry().getServiceInfo(sid, aRecord);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncMonitorAddFilter(CEnvelope aEnvelope, CRecord aRecord) {
        IId[] sids;
        IId nid = CRecordNanoServiceMonitorAddFilter.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        CTargetAddress observer = CRecordNanoServiceMonitorAddFilter.getObserver(aRecord, aEnvelope.getSender());
        CUtilCheck.checkNotNull(observer, "Missing Observer address", new Object[0]);
        IId sid = CRecordNanoServiceMonitorAddFilter.getSid(aRecord, null);
        if (sid != null) {
            namespace.getNanoServiceRegistry().getNanoServiceMonitor().addFilter(observer, sid);
        }
        if ((sids = CRecordNanoServiceMonitorAddFilter.getSids(aRecord, null)) != null) {
            for (IId oneSid : sids) {
                namespace.getNanoServiceRegistry().getNanoServiceMonitor().addFilter(observer, oneSid);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncMonitorRemoveAllFilter(CEnvelope aEnvelope, CRecord aRecord) {
        IId nid = CRecordNanoServiceMonitorRemoveAllFilter.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        CTargetAddress observer = CRecordNanoServiceMonitorRemoveAllFilter.getObserver(aRecord, aEnvelope.getSender());
        CUtilCheck.checkNotNull(observer, "Missing Observer address", new Object[0]);
        namespace.getNanoServiceRegistry().getNanoServiceMonitor().removeAddress(observer);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncMonitorRemoveFilter(CEnvelope aEnvelope, CRecord aRecord) {
        IId[] sids;
        IId nid = CRecordNanoServiceMonitorRemoveFilter.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        CTargetAddress observer = CRecordNanoServiceMonitorRemoveFilter.getObserver(aRecord, aEnvelope.getSender());
        CUtilCheck.checkNotNull(observer, "Missing Observer address", new Object[0]);
        IId sid = CRecordNanoServiceMonitorRemoveFilter.getSid(aRecord, null);
        if (sid != null) {
            namespace.getNanoServiceRegistry().getNanoServiceMonitor().removeFilter(observer, sid);
        }
        if ((sids = CRecordNanoServiceMonitorRemoveFilter.getSids(aRecord, null)) != null) {
            for (IId oneSid : sids) {
                namespace.getNanoServiceRegistry().getNanoServiceMonitor().removeFilter(observer, oneSid);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRegisterService(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        IId nid = CRecordNanoServiceAddObservers.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        IId sid = CRecordNanoServiceRegisterService.getSid(aRecord, null);
        CUtilCheck.checkNotNull(sid, "Missing Service ID", new Object[0]);
        String name = CRecordNanoServiceRegisterService.getName(aRecord, "");
        CUtilCheck.checkEmptyString(name, "Missing Service Name", new Object[0]);
        namespace.getNanoServiceRegistry().addNanoService(sid, name);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRegisterServiceAndObserver(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        IId nid = CRecordNanoServiceAddObservers.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        IId sid = CRecordNanoServiceRegisterServiceAndObserver.getSid(aRecord, null);
        CUtilCheck.checkNotNull(sid, "Missing Service ID", new Object[0]);
        String name = CRecordNanoServiceRegisterServiceAndObserver.getName(aRecord, "");
        CUtilCheck.checkEmptyString(name, "Missing Service Name", new Object[0]);
        CTargetAddress address = CRecordNanoServiceRegisterServiceAndObserver.getObserver(aRecord, null);
        CUtilCheck.checkNotNull(address, "Missing Observer Address", new Object[0]);
        INanoServiceRegistry reg = namespace.getNanoServiceRegistry();
        reg.addNanoService(sid, name);
        reg.addObserver(sid, address, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveObserver(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        IId nid = CRecordNanoServiceAddObservers.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        IId sid = CRecordNanoServiceRemoveObserver.getSid(aRecord, null);
        CUtilCheck.checkNotNull(sid, "Missing Service ID", new Object[0]);
        CTargetAddress address = CRecordNanoServiceRemoveObserver.getObserver(aRecord, null);
        CUtilCheck.checkNotNull(address, "Missing Observer Address", new Object[0]);
        namespace.getNanoServiceRegistry().removeObserver(sid, address);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveObservers(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        IId nid = CRecordNanoServiceAddObservers.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        IId[] sids = CRecordNanoServiceRemoveObservers.getSids(aRecord, null);
        CUtilCheck.checkNotNull(sids, "Missing Service IDs", new Object[0]);
        CTargetAddress address = CRecordNanoServiceRemoveObservers.getObserver(aRecord, null);
        CUtilCheck.checkNotNull(address, "Missing Observer Address", new Object[0]);
        INanoServiceRegistry reg = namespace.getNanoServiceRegistry();
        for (IId sid : sids) {
            reg.removeObserver(sid, address);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        CTargetAddress address = this.getAddress();
        this.mMyNanoServiceRegistry.addNanoServiceAndObserver(CRecordNanoServiceRegisterServiceAndObserver.class, address, false);
        this.mMyNanoServiceRegistry.addNanoServiceAndObserver(CRecordNanoServiceDeregisterService.class, address, false);
        this.mMyNanoServiceRegistry.addNanoServiceAndObserver(CRecordNanoServiceAddObserver.class, address, false);
        this.mMyNanoServiceRegistry.addNanoServiceAndObserver(CRecordNanoServiceAddObservers.class, address, false);
        this.mMyNanoServiceRegistry.addNanoServiceAndObserver(CRecordNanoServiceRemoveObserver.class, address, false);
        this.mMyNanoServiceRegistry.addNanoServiceAndObserver(CRecordNanoServiceRemoveObservers.class, address, false);
        this.mMyNanoServiceRegistry.addNanoServiceAndObserver(CRecordNanoServiceGetServiceInfo.class, address, false);
        this.mMyNanoServiceRegistry.addNanoServiceAndObserver(CRecordNanoServiceTriggerRecall.class, address, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncTriggerRecall(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        IId nid = CRecordNanoServiceAddObservers.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        IId sid = CRecordNanoServiceTriggerRecall.getSid(aRecord, null);
        CUtilCheck.checkNotNull(sid, "Missing Service ID", new Object[0]);
        boolean allObserver = CRecordNanoServiceTriggerRecall.getAllObserver(aRecord, true);
        INanoServiceRegistry reg = namespace.getNanoServiceRegistry();
        CTargetAddress sender = aEnvelope.getSender();
        if (allObserver) {
            reg.recallTrigger(sid);
        } else {
            reg.recallTrigger(sid, sender);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncUpdateServices(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        IId nid = CRecordNanoServiceAddObservers.getNid(aRecord, null);
        CUtilCheck.checkNotNull(nid, "Missing Namespace ID", new Object[0]);
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        CUtilCheck.checkNotNull(namespace, "Namespace %s not found", nid.toString());
        CRecord[] nanoServices = CRecordNanoServiceUpdateServices.getServices(aRecord, null);
        CUtilCheck.checkNotNull(nanoServices, "Missing Services", new Object[0]);
        INanoServiceRegistry reg = namespace.getNanoServiceRegistry();
        for (CRecord rec : nanoServices) {
            IId sid = CRecordOfANanoService.getSid(rec, null);
            String name = CRecordOfANanoService.getName(rec, "");
            CTargetAddress[] observer = CRecordOfANanoService.getObserver(rec, null);
            if (sid == null) continue;
            reg.addNanoService(sid, name);
            for (CTargetAddress address : observer) {
                reg.addObserver(sid, address, false);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }
}

