/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namedb;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.namedb.IGeneralIdDatabase;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

final class CGeneralIdDatabase
implements IGeneralIdDatabase {
    private static final ILogger LOG = CLoggerFactory.getLogger(CGeneralIdDatabase.class);
    private static final int HASH_MAP_SIZE = 100;
    private final Map<IId, String> mDb = new ConcurrentHashMap<IId, String>(100);

    CGeneralIdDatabase() {
    }

    @Override
    public void dump() {
        LOG.info("IdNameDb: size={}", this.mDb.size());
        for (Map.Entry<IId, String> entry : this.mDb.entrySet()) {
            LOG.trace("{} = {}", entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public String getName(@NotNull IId aId) {
        String name = this.mDb.get(aId);
        if (name == null) {
            name = aId.toString();
        }
        return name;
    }

    @Override
    public String getNameOrNull(@NotNull IId aId) {
        return this.mDb.get(aId);
    }

    @Override
    public void putName(@NotNull IId aId, @NotNull String aName) {
        this.mDb.put(aId, aName);
    }

    @Override
    public void removeName(@NotNull IId aId) {
        this.mDb.remove(aId);
    }
}

