/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.sender;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.kernel.transport.records.CRecordRouteMessage;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.EPriority;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.IMicroServiceTransportHandler;
import de.sillysky.nyssr.message.hook.EMessageHookCause;
import de.sillysky.nyssr.message.hook.IMessageHookRegistry;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceInternal;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMessageSender
implements IMessageSender,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CMessageSender.class);
    private IKernelConfiguration mKernelConfiguration;
    private IMessageHookRegistry mMessageHookRegistry;
    private INamespaceRegistry mNamespaceRegistry;
    private final Map<IId, AtomicInteger> mMsgStat = new HashMap<IId, AtomicInteger>();

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(IMessageHookRegistry.class);
        aDependencyList.add(INamespaceRegistry.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mKernelConfiguration = aServiceRegistry.getService(IKernelConfiguration.class);
        this.mMessageHookRegistry = aServiceRegistry.getService(IMessageHookRegistry.class);
        this.mNamespaceRegistry = aServiceRegistry.getService(INamespaceRegistry.class);
        aServiceRegistry.registerService(IMessageSender.class, this);
    }

    private void checkNullMsg(@Nullable CMessage aMsg) throws CException {
        if (aMsg == null) {
            throw new CException(2003).append("Can't send null message.");
        }
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    @Override
    @NotNull
    public CNodeAddress getNodeAddress() {
        return this.mKernelConfiguration.getNodeAddress();
    }

    @Override
    public boolean isLocal(@NotNull CNodeAddress aNode) {
        return aNode == null || !aNode.isValid() || aNode.equals(this.getNodeAddress());
    }

    @Override
    public void send(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.send(new CMessage(aEnvelope, aRecord));
    }

    @Override
    public void send(@NotNull CMessage aMessage) throws CException {
        this.checkNullMsg(aMessage);
        this.checkRecordId(aMessage);
        this.fillTimestamps(aMessage);
        this.updateStatistics(aMessage);
        if (!this.hasValidReceiver(aMessage) && this.checkMicroService(aMessage)) {
            return;
        }
        if (this.checkRemote(aMessage)) {
            return;
        }
        CResult result = this.dispatch(aMessage);
        if (result != null) {
            LOG.error(result.toString());
            throw new CException(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatistics(@NotNull CMessage aAMessage) {
        IId id = aAMessage.getRecord().getId();
        Map<IId, AtomicInteger> map = this.mMsgStat;
        synchronized (map) {
            AtomicInteger i = this.mMsgStat.get(id);
            if (i == null) {
                this.mMsgStat.put(id, new AtomicInteger(1));
            } else {
                i.incrementAndGet();
            }
        }
    }

    private boolean hasValidReceiver(@NotNull CMessage aMessage) {
        CTargetAddress receiver = aMessage.getEnvelope().getReceiver();
        return CIdFactory.isValid(receiver.getNID());
    }

    private void fillTimestamps(@NotNull CMessage aMessage) {
        CEnvelope env = aMessage.getEnvelope();
        if (env.isAnswer()) {
            env.setTimeSendBack(Instant.now());
        } else {
            env.setTimeSend(Instant.now());
        }
    }

    private boolean checkRemote(@NotNull CMessage aMessage) throws CException {
        boolean isLocal = this.isLocal(aMessage.getEnvelope().getReceiver().getNodeAddress());
        if (!isLocal) {
            this.sendToRemote(aMessage);
            return true;
        }
        return false;
    }

    private void checkRecordId(@NotNull CMessage aMessage) throws CException {
        IId mid = aMessage.getRecord().getId();
        if (IId.INVALID.equals(mid)) {
            CResult result = new CResult(2004).append("Message has no valid ID. Dropped. MSG=").append(aMessage.toString());
            LOG.error(result.toString());
            throw new CException(result);
        }
    }

    @Nullable
    private CResult dispatch(@NotNull CMessage aMessage) throws CException {
        CEnvelope env = aMessage.getEnvelope();
        CTargetAddress receiver = env.getReceiver();
        IId nid = receiver.getNID();
        if (CIdFactory.isEmpty(nid) && CIdFactory.isEmpty(nid = env.getSender().getNID())) {
            return new CResult(2509).append("Message has no namespace ID. Dropped. MSG=").append(aMessage.toString());
        }
        INamespace namespace = this.mNamespaceRegistry.getNamespace(nid);
        if (namespace == null) {
            return new CResult(2509).append("Namespace ID of message unknown. Dropped. MSG=").append(aMessage.toString());
        }
        CMessage result = ((INamespaceInternal)((Object)namespace)).dispatch(aMessage);
        if (result != null) {
            this.sendBack(result);
        }
        return null;
    }

    private boolean checkMicroService(@NotNull CMessage aMessage) {
        IMicroServiceTransportHandler handler;
        IId microServiceId = aMessage.getEnvelope().getMicroServiceId();
        if (microServiceId != null && microServiceId.isValid() && (handler = CServiceRegistry.getInstance().getService(IMicroServiceTransportHandler.class)) != null) {
            return handler.handleMessage(aMessage);
        }
        return false;
    }

    @Override
    public void sendBack(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.sendBack(new CMessage(aEnvelope, aRecord));
    }

    @Override
    public void sendBack(@NotNull CMessage aMsg) throws CException {
        int resultCode;
        this.checkNullMsg(aMsg);
        CEnvelope env = aMsg.getEnvelope();
        if (env.isAnswer()) {
            return;
        }
        if (!(env.wantAnswer() || (resultCode = env.getResultCode()) != 0 && resultCode != 2001)) {
            return;
        }
        if (env.isBlocked()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Message is blocked. Ignore: {}", aMsg);
            }
        } else {
            CResult error = env.swap();
            if (error == null) {
                env.setTimeSendBack(Instant.now());
                env.setIsAnswer(true);
                env.setPriority(EPriority.HIGH);
                this.send(aMsg);
            } else {
                LOG.error("Can't send back message (drop): {}:\n{}", error, aMsg);
            }
        }
    }

    @Override
    public void sendNotification(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        aEnvelope.setWantAnswer(false);
        this.send(aEnvelope, aRecord);
    }

    @Override
    public void sendNotification(@NotNull CMessage aMsg) throws CException {
        aMsg.getEnvelope().setWantAnswer(false);
        this.send(aMsg);
    }

    @Override
    public void sendRequest(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        aEnvelope.setWantAnswer(true);
        this.send(aEnvelope, aRecord);
    }

    @Override
    public void sendRequest(@NotNull CMessage aMsg) throws CException {
        aMsg.getEnvelope().setWantAnswer(true);
        this.send(aMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<IId, Integer> getRecordIdStatistic() {
        HashMap<IId, Integer> map = new HashMap<IId, Integer>();
        Map<IId, AtomicInteger> map2 = this.mMsgStat;
        synchronized (map2) {
            for (Map.Entry<IId, AtomicInteger> entry : this.mMsgStat.entrySet()) {
                map.put(entry.getKey(), entry.getValue().get());
            }
        }
        return map;
    }

    private void sendToRemote(CMessage aMessage) throws CException {
        CMessage msgToSend = aMessage;
        if ((msgToSend = this.mMessageHookRegistry.invokeMessageHook(msgToSend, EMessageHookCause.SEND)) == null) {
            return;
        }
        INamespace transportNamespace = this.mNamespaceRegistry.getNamespace(CWellKnownNID.TRANSPORT);
        if (transportNamespace == null) {
            CException ex = new CException(5307).append("No Transport Namespace found.");
            LOG.error(ex.toString());
            throw ex;
        }
        CEnvelope env2 = CEnvelope.forLocalNanoService(CRecordRouteMessage.class);
        env2.setOnlyLocal(true);
        env2.setLogEnabled(false);
        CRecord rec = CRecordRouteMessage.create();
        CRecordRouteMessage.setMessage(rec, msgToSend);
        this.sendNotification(env2, rec);
    }
}

