/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.queue;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.message.queue.CAbstractMessageQueue;
import de.sillysky.nyssr.impl.message.queue.CMessageQueueRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.IPostMan;
import org.jetbrains.annotations.NotNull;

class CSyncMessageQueue
extends CAbstractMessageQueue {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSyncMessageQueue.class);
    private final boolean mForwardExceptions;

    CSyncMessageQueue(CMessageQueueRegistry aRegistry, IMessageSender aMessageSender, IId aId, String aDesc, IPostMan aPostMan, boolean aForwardExceptions) {
        super(aRegistry, aMessageSender, aId, aDesc, aPostMan);
        this.mForwardExceptions = aForwardExceptions;
    }

    @Override
    public void dismiss() {
        this.deregisterMe();
    }

    @Override
    @NotNull
    public Thread getThread() {
        return Thread.currentThread();
    }

    @Override
    public synchronized void offer(@NotNull CMessage aMsg) {
        try {
            this.call(aMsg);
        }
        catch (Exception e) {
            if (this.mForwardExceptions) {
                throw new RuntimeException(e);
            }
            LOG.error(e, "Exception on dispatch message {}: {}", aMsg);
            aMsg.getEnvelope().setResult(2, e.getMessage());
        }
        try {
            this.sendBack(aMsg);
        }
        catch (Exception e) {
            LOG.error(e, "Exception on sending back message {}: {}", aMsg);
        }
    }

    @Override
    public void start() {
    }
}

