/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.log;

import de.sillysky.nyssr.impl.log.CLogConfiguration;
import de.sillysky.nyssr.impl.log.CLogger;
import de.sillysky.nyssr.log.CLogDto;
import de.sillysky.nyssr.log.ELevel;
import de.sillysky.nyssr.log.ILogConfiguration;
import de.sillysky.nyssr.log.ILogMachine;
import de.sillysky.nyssr.log.ILogWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class CLogMachine
implements ILogMachine {
    private static ILogMachine mInstance;
    private final CLogConfiguration mConfiguration;
    private final Map<String, CLogger> mLoggers = new ConcurrentHashMap<String, CLogger>();
    private final List<ILogWriter> mWriters = new ArrayList<ILogWriter>();
    private final ELevel mLevel = ELevel.INFO;

    CLogMachine() {
        this.mConfiguration = new CLogConfiguration(this);
    }

    @NotNull
    public static ILogMachine getInstance() {
        if (mInstance == null) {
            mInstance = new CLogMachine();
        }
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWriter(@NotNull ILogWriter aWriter) {
        List<ILogWriter> list = this.mWriters;
        synchronized (list) {
            try {
                aWriter.start();
                this.mWriters.add(aWriter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ELevel calcLevel(String aName) {
        ELevel lvl = ELevel.OFF;
        List<ILogWriter> list = this.mWriters;
        synchronized (list) {
            for (ILogWriter lw : this.mWriters) {
                ELevel level = lw.calcLevel(aName);
                if (level.ordinal() >= lvl.ordinal()) continue;
                lvl = level;
            }
        }
        return lvl;
    }

    @Override
    public ILogConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    public ELevel getLevel() {
        return this.mLevel;
    }

    @Override
    @NotNull
    public CLogger getLogger(@NotNull Class<?> aClass) {
        String name = aClass.getName();
        CLogger l = this.mLoggers.get(name);
        if (l == null) {
            l = new CLogger(this, aClass);
            l.setLevel(this.calcLevel(name));
            this.mLoggers.put(name, l);
        }
        return l;
    }

    @Override
    @NotNull
    public CLogger getLogger(@NotNull String aName) {
        CLogger l = this.mLoggers.get(aName);
        if (l == null) {
            l = new CLogger(this, aName);
            l.setLevel(this.calcLevel(aName));
            this.mLoggers.put(aName, l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(int aStackDepth, @NotNull CLogDto aDto) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (aStackDepth < 0 || aStackDepth >= stackTrace.length) {
            return;
        }
        StackTraceElement st = stackTrace[aStackDepth];
        aDto.setClassWhereLogged(st.getClassName());
        aDto.setMethodWhereLogged(st.getMethodName());
        aDto.setFileWhereLogged(st.getFileName());
        aDto.setLineWhereLogged(st.getLineNumber());
        aDto.setNativeMethod(st.isNativeMethod());
        Thread thread = Thread.currentThread();
        aDto.setThreadName(thread.getName());
        aDto.setThreadId(thread.getId());
        aDto.setThreadPriority(thread.getPriority());
        List<ILogWriter> list = this.mWriters;
        synchronized (list) {
            for (ILogWriter w : this.mWriters) {
                int theirs;
                ELevel level = w.calcLevel(aDto.getLoggerName());
                int mine = level.ordinal();
                if (mine > (theirs = aDto.getLevel().ordinal())) continue;
                try {
                    w.write(aDto);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWriter(@NotNull ILogWriter aWriter) {
        List<ILogWriter> list = this.mWriters;
        synchronized (list) {
            this.mWriters.remove(aWriter);
        }
    }

    @Override
    public void update() {
        Collection<CLogger> loggers = this.mLoggers.values();
        for (CLogger l : loggers) {
            Class<?> clazz = l.getLoggerClass();
            String name = clazz == null ? l.getName() : clazz.getName();
            ELevel level = this.calcLevel(name);
            l.setLevel(level);
        }
    }

    @Override
    public Collection<ILogWriter> getWriters() {
        return new ArrayList<ILogWriter>(this.mWriters);
    }
}

