/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.log;

import de.sillysky.nyssr.log.CDefaultConsoleLogWriter;
import de.sillysky.nyssr.log.CDefaultMessageFormatter;
import de.sillysky.nyssr.log.ELevel;
import de.sillysky.nyssr.log.ILogConfiguration;
import de.sillysky.nyssr.log.ILogMachine;
import de.sillysky.nyssr.log.ILogWriter;
import de.sillysky.nyssr.log.IMessageFormatter;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

public class CLogConfiguration
implements ILogConfiguration {
    private final ILogMachine mMachine;

    CLogConfiguration(ILogMachine aMachine) {
        this.mMachine = aMachine;
    }

    @Override
    public ILogConfiguration addWriter(@NotNull ILogWriter aWriter) {
        this.mMachine.addWriter(aWriter);
        return this;
    }

    @NotNull
    private Object loadClass(@NotNull String aClassName) throws Exception {
        Class<?> clazz = Class.forName(aClassName);
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    private void loadFileName(@NotNull Preferences aWriterNode, ILogWriter aLw) {
        String value = aWriterNode.get("file.path", null);
        if (value != null && !value.isEmpty()) {
            Path path = Paths.get(value, new String[0]);
            aLw.setFilePath(path);
        }
        if ((value = aWriterNode.get("file.append", "false")) != null && !value.isEmpty()) {
            boolean append = Boolean.parseBoolean(value);
            aLw.setFileAppend(append);
        }
    }

    private void loadFormatter(@NotNull Preferences aWriterNode, ILogWriter aLw) {
        String formatterClassName = aWriterNode.get("formatter.class.name", null);
        if (formatterClassName != null && !formatterClassName.isEmpty()) {
            try {
                Object o1 = this.loadClass(formatterClassName);
                if (o1 instanceof IMessageFormatter) {
                    IMessageFormatter mf = (IMessageFormatter)o1;
                    aLw.setMessageFormatter(mf);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadLogLevel(@NotNull Preferences aWriterNode, ILogWriter aLw) {
        String value = aWriterNode.get("level", null);
        if (value != null && !value.isEmpty()) {
            value = value.toUpperCase();
            ELevel level = ELevel.convert(value, ELevel.INFO);
            aLw.setLevel(level);
        }
    }

    private void loadLogLevels(@NotNull Preferences aWriterNode, @NotNull ILogWriter aLw) {
        try {
            String[] keys;
            Preferences nodeLevels = aWriterNode.node("levels");
            for (String key : keys = nodeLevels.keys()) {
                String value = nodeLevels.get(key, "info");
                ELevel level = ELevel.convert(value, ELevel.INFO);
                if (level == null) continue;
                aLw.setLevel(key, level);
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ILogConfiguration readPreferences(@NotNull String aCompanyName, @NotNull String aNodeName) throws BackingStoreException {
        Preferences root = Preferences.userRoot();
        Preferences company = root.node(aCompanyName);
        Preferences nodes = company.node("nodes");
        Preferences node = nodes.node(aNodeName);
        Preferences log = node.node("logging");
        Preferences writer = log.node("writer");
        String[] children = writer.childrenNames();
        if (children.length > 0) {
            for (String child : children) {
                Preferences writerNode = writer.node(child);
                try {
                    this.readWriterParams(writerNode);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            CDefaultConsoleLogWriter lw = new CDefaultConsoleLogWriter();
            lw.setLevel(ELevel.DEBUG);
            lw.setMessageFormatter(new CDefaultMessageFormatter());
            this.addWriter(lw);
            this.mMachine.update();
        }
        return this;
    }

    private void readWriterParams(@NotNull Preferences aWriterNode) throws Exception {
        Object o;
        String className = aWriterNode.get("writer.class.name", null);
        if (className != null && !className.isEmpty() && (o = this.loadClass(className)) instanceof ILogWriter) {
            ILogWriter lw = (ILogWriter)o;
            this.loadLogLevel(aWriterNode, lw);
            this.loadFormatter(aWriterNode, lw);
            this.loadLogLevels(aWriterNode, lw);
            this.loadFileName(aWriterNode, lw);
            this.addWriter(lw);
        }
        this.mMachine.update();
    }

    @Override
    public ILogConfiguration removeWriter(@NotNull ILogWriter aWriter) {
        this.mMachine.removeWriter(aWriter);
        return this;
    }

    @Override
    public Collection<ILogWriter> getWriters() {
        return this.mMachine.getWriters();
    }

    @Override
    public void update() {
        this.mMachine.update();
    }
}

