/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel.config;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CRuntimeError;
import de.sillysky.nyssr.impl.configuration.requester.CConfigurationRequester;
import de.sillysky.nyssr.impl.kernel.config.CCommandLinePrinter;
import de.sillysky.nyssr.impl.kernel.config.CConfigurationEntry;
import de.sillysky.nyssr.impl.kernel.config.CConfigurationEntryList;
import de.sillysky.nyssr.impl.kernel.config.EConfigurationSource;
import de.sillysky.nyssr.impl.kernel.config.IDependencies;
import de.sillysky.nyssr.impl.kernel.config.file.reader.IConfigValueHandler;
import de.sillysky.nyssr.kernel.configuration.ESystemExit;
import de.sillysky.nyssr.kernel.configuration.ETypeOfNode;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogConfiguration;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.CUtilBoolean;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilSystem;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.files.CUtilPath;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.version.CVersion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CKernelConfiguration
implements IKernelConfiguration,
IService,
IConfigValueHandler {
    private static final ILogger LOG = CLoggerFactory.getLogger("configuration");
    private static final ILogger LOG_STARTUP = CLoggerFactory.getLogger("startup");
    private static final CVersion KERNEL_VERSION = CVersion.fromFilename("1.0.0-SNAPSHOT");
    private static final String WILD_CARD = "*";
    private static final String PREFERENCE_DELIMITER = "/";
    private final UUID mInstanceID = UUID.randomUUID();
    private Preferences mKernelPreferences;
    private ETypeOfNode mTypeOfNode;
    private LocalDateTime mStartTime;
    private CNodeAddress mNodeAddress = CNodeAddress.EMPTY;
    private Path mBasePath;
    private Path mModuleConfigDir;
    private Path mStoragePath;
    private Preferences mNodePreferences;
    private UUID mLicense;
    private String mConfigurationName;
    private CConfigurationEntryList mConfigurationEntryList = new CConfigurationEntryList();
    private final Map<String, String> mEnvironment;
    private boolean mLogIsAvailable = false;
    private final IDependencies mDependencies;
    private Path mPathOfLibraries;

    CKernelConfiguration(@NotNull IDependencies aDependencies, @NotNull CStringProperties aKernelProperties, @NotNull Map<String, String> aEnvironment) {
        System.out.println(CCommandLinePrinter.javaVmName());
        List<String> ss = CCommandLinePrinter.vmArguments();
        for (String s : ss) {
            System.out.println(s);
        }
        this.mDependencies = aDependencies;
        this.mEnvironment = aEnvironment;
        for (String key : aKernelProperties.getKeys()) {
            String value = aKernelProperties.get(key);
            String normalizedKey = CUtilNormalize.normalizePreference(key);
            this.mConfigurationEntryList.add(new CConfigurationEntry(EConfigurationSource.COMMAND_LINE, "kernel.configuration", normalizedKey, value));
        }
        this.readEnvironmentVariables();
    }

    @Override
    @NotNull
    public ETypeOfNode getTypeOfNode() {
        return this.mTypeOfNode;
    }

    @Override
    public void activate(IServiceRegistry aServiceRegistry) throws CException, BackingStoreException {
        this.mStartTime = LocalDateTime.now();
        CLoggerFactory.setStartTime(this.mStartTime);
        this.printLogo();
        this.printClasspath();
        this.resolveLibPath();
        this.resolveNodeId();
        this.importRemotePreferenceFile();
        this.importLocalPreferenceFile();
        this.dumpConfigProperties();
        this.resolveBasePath();
        LOG.info("Base directory = {}", this.mBasePath);
        LOG.info(CUtilString.LINE_CRLF);
        this.loadConfigFiles();
        this.resolveTypeOfNode();
        this.load();
        this.takeOverConfigProperties();
        this.configureLog();
        this.exportPreferences();
        if (aServiceRegistry != null) {
            aServiceRegistry.registerService(IKernelConfiguration.class, this);
        }
        this.printProperties();
    }

    private void resolveLibPath() {
        try {
            this.mPathOfLibraries = Paths.get(CUtilSystem.findJarPathString(this.getClass()), new String[0]);
            this.mDependencies.getNodeStringProperties().set("path.libs", this.mPathOfLibraries.toString());
        }
        catch (URISyntaxException aException) {
            LOG.error(aException);
        }
    }

    @Override
    public Path getPathOfLibraries() {
        return this.mPathOfLibraries;
    }

    private void printClasspath() {
        String[] classPathValues;
        this.log(false, "ClassPath:");
        String classpath = System.getProperty("java.class.path");
        for (String s : classPathValues = classpath.split(File.pathSeparator)) {
            this.log(false, s);
        }
    }

    private void printLogo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        this.addLogoLine(sb, "                                                            __       ");
        this.addLogoLine(sb, "     ____  ___ __   ______ _____________      ____   ____ _/  |_     ");
        this.addLogoLine(sb, "    /    \\|   |  | /  ___//  ___/\\_  ___\\    /    \\ / __ \\\\   __\\    ");
        this.addLogoLine(sb, "   |   |  \\\\___  | \\___ \\ \\___ \\  |  |      |   |  \\\\ ___/|  |       ");
        this.addLogoLine(sb, "   |___|__//_____|/_____//_____/  |__|   @  |___|__/ \\___||__|       ");
        this.addLogoLine(sb, "                                                                     ");
        this.addLogoLine(sb, "   (c) 2024 by sillysky software laboratories                        ");
        this.addLogoLine(sb, "                                                                     ");
        System.out.println(sb);
    }

    private void addLogoLine(@NotNull StringBuilder aSb, String aText) {
        aSb.append("\u001b[42m").append("\u001b[97m").append(aText).append("\u001b[0m").append("\n");
    }

    private void removeSystemProperties() {
        if (this.mKernelPreferences != null) {
            Properties properties = System.getProperties();
            for (Object key : properties.keySet()) {
                if (!(key instanceof String)) continue;
                String key1 = (String)key;
                this.mKernelPreferences.remove(key1);
            }
        }
    }

    private void removeEnvironmentVars() {
        if (this.mKernelPreferences != null) {
            for (Map.Entry<String, String> entry : this.mEnvironment.entrySet()) {
                String key = entry.getKey();
                this.mKernelPreferences.remove(key);
            }
        }
    }

    private void dumpConfigProperties() {
        if (LOG.isDebugEnabled() && this.mConfigurationEntryList != null) {
            StringBuilder sb = new StringBuilder(2000);
            sb.append(CUtilString.LINE_CRLF);
            sb.append("ConfigProperties");
            sb.append(CUtilString.CRLF);
            TreeSet<String> set = new TreeSet<String>(this.mConfigurationEntryList.keySet());
            for (String s : set) {
                sb.append(this.mConfigurationEntryList.get(s));
                sb.append(CUtilString.CRLF);
            }
            sb.append(CUtilString.LINE);
            LOG.debug(sb.toString());
        }
    }

    private void importRemotePreferenceFile() {
        String tcpAddress = this.getConfigValue("kernel.configuration", "preference.tcp", false);
        if (CUtilString.isValid(tcpAddress)) {
            System.out.println("Get remote Configuration from " + tcpAddress);
            CConfigurationRequester cr = new CConfigurationRequester();
            String configuration = cr.requestConfiguration(this.mNodeAddress.getNodeId().toString(), tcpAddress);
            if (CUtilString.isValid(configuration)) {
                try (ByteArrayInputStream stream = new ByteArrayInputStream(configuration.getBytes(StandardCharsets.UTF_8));){
                    Preferences.importPreferences(stream);
                    System.err.println("Remote Configuration from " + tcpAddress + " successfully imported.");
                }
                catch (Exception aE) {
                    System.err.println("Error reading from Stream");
                    aE.printStackTrace();
                }
            } else {
                System.err.println("Got no valid configuration from remote");
            }
            return;
        }
        System.out.println("No remote Preference Provider given.");
    }

    private void importLocalPreferenceFile() {
        String pathString = this.getConfigValue("kernel.configuration", "preference.import", false);
        if (pathString.isEmpty()) {
            System.out.println("No local Preference File given.");
        } else {
            System.out.println("Import local Preference File " + pathString);
            Preferences userRoot = this.getUserRoot();
            String alreadyImported = userRoot.get("preferences.imported", null);
            if (alreadyImported == null) {
                File file = Paths.get(pathString, new String[0]).toFile();
                if (!file.exists()) {
                    System.err.println("Preference File doesn't exist: " + pathString);
                } else {
                    try (FileInputStream fis = new FileInputStream(file);){
                        Preferences.importPreferences(fis);
                        userRoot.put("preferences.imported", LocalDateTime.now().toString());
                    }
                    catch (IOException | InvalidPreferencesFormatException aE) {
                        System.err.println("Error importing Preference File.");
                        aE.printStackTrace();
                    }
                }
            } else {
                System.out.println("Preferences already imported " + alreadyImported + ", skip.");
            }
        }
    }

    private void exportPreferences() {
        Preferences userRoot = this.getUserRoot();
        File file = this.mStoragePath.resolve(this.mNodeAddress.getNodeId() + ".xml").toFile();
        try (FileOutputStream fos = new FileOutputStream(file);){
            userRoot.exportSubtree(fos);
        }
        catch (IOException | BackingStoreException aE) {
            LOG.error(aE, "Error exporting configuration {}", userRoot.name());
        }
    }

    private byte[] exportPreferencesToByteArray(@NotNull Preferences aPreferences) {
        byte[] byArray;
        ByteArrayOutputStream s1 = new ByteArrayOutputStream();
        try {
            aPreferences.exportSubtree(s1);
            s1.close();
            byArray = s1.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    s1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | BackingStoreException aE) {
                LOG.error(aE, "Error exporting configuration {}", aPreferences.name());
                return null;
            }
        }
        s1.close();
        return byArray;
    }

    private boolean checkIfDirectory(@NotNull Path aPath) {
        File f = aPath.toFile();
        return f.exists() && f.isDirectory();
    }

    private boolean createDirectory(@NotNull Path aPath) {
        File f = aPath.toFile();
        if (f.exists()) {
            return f.isDirectory();
        }
        return f.mkdirs();
    }

    @Override
    @NotNull
    public CTargetAddress completeAddress(@NotNull CTargetAddress aAddress) {
        if (!aAddress.getNodeId().isValid()) {
            return aAddress.changeNodeId(this.mNodeAddress.getNodeId());
        }
        return aAddress;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    @Override
    @NotNull
    public Path getBasePath() {
        return this.mBasePath;
    }

    @Override
    @NotNull
    public Collection<String> getConfigurationNames() throws BackingStoreException {
        Preferences userRoot = this.getUserRoot();
        String[] children = userRoot.childrenNames();
        return new ArrayList<String>(Arrays.asList(children));
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.getConfigValue("kernel.configuration", "node.description", true);
    }

    @Override
    @NotNull
    public UUID getInstanceId() {
        return this.mInstanceID;
    }

    @Override
    @NotNull
    public CVersion getKernelVersion() {
        return KERNEL_VERSION;
    }

    @Override
    @NotNull
    public UUID getLicense() {
        return this.mLicense;
    }

    @Override
    @NotNull
    public Path getConfigurationPath() {
        return this.mModuleConfigDir;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getConfigValue("kernel.configuration", "node.id", true);
    }

    @Override
    @NotNull
    public Preferences getPreferences(@NotNull String aConfigurationName) {
        return this.getUserRoot().node(aConfigurationName);
    }

    private boolean isPreferencesAvailable() {
        return CUtilString.isValid(this.mConfigurationName);
    }

    @Nullable
    private Preferences getPreferencesOrNull(@NotNull String aConfigurationName) {
        if (this.isPreferencesAvailable()) {
            return this.getUserRoot().node(aConfigurationName);
        }
        return null;
    }

    @Override
    @NotNull
    public CStringProperties getSystemProperties(@NotNull String aConfigurationName) {
        try {
            Preferences prefs = this.getPreferences(aConfigurationName);
            return this.readProperties(prefs);
        }
        catch (BackingStoreException aE) {
            return new CStringProperties();
        }
    }

    @Override
    @NotNull
    public CStringProperties getUserProperties(@NotNull String aConfigurationName) {
        try {
            Preferences prefs = this.getUserRoot().node(aConfigurationName);
            return this.readProperties(prefs);
        }
        catch (BackingStoreException aE) {
            return new CStringProperties();
        }
    }

    @Override
    @NotNull
    public LocalDateTime getStartTime() {
        return this.mStartTime;
    }

    @Override
    @Nullable
    public Path getStoragePath() {
        return this.mStoragePath;
    }

    @Override
    @NotNull
    public Preferences getUserRoot() {
        Preferences nodes = this.getNodesNode();
        if (CUtilString.isValid(this.mConfigurationName)) {
            return nodes.node(this.mConfigurationName);
        }
        return nodes.node("dummy");
    }

    private Preferences getNodesNode() {
        Preferences userRoot = Preferences.userRoot();
        Preferences company = userRoot.node("sillysky");
        return company.node("nodes");
    }

    @Override
    @NotNull
    public String getVendor() {
        return this.getConfigValue("kernel.configuration", "vendor", true);
    }

    private boolean isDumpEnabled() {
        String value = this.getConfigValue("kernel.configuration", "dump.properties", true);
        return Boolean.parseBoolean(value);
    }

    private void load() {
        this.resolveSegmentId();
        this.resolveLicenseId();
        this.resolveStorageDirectory();
    }

    private void loadConfigFiles() throws CException {
        this.mModuleConfigDir = this.resolvePath("config.dir", "config");
        this.mDependencies.getNodeStringProperties().set("path.configuration.files", this.mModuleConfigDir.toString());
        this.createDirectory(this.mModuleConfigDir);
        LOG.info("Module configuration directory = {}", this.mModuleConfigDir.toString());
        try {
            this.mDependencies.getConfigFileReader().readConfigFiles(this.mModuleConfigDir, this);
        }
        catch (IOException e) {
            throw new CException(2201).append(e);
        }
    }

    private void printProperties() {
        if (this.isDumpEnabled()) {
            LOG.info(CUtilString.LINE_CRLF);
            LOG.info("System Properties:");
            Properties properties = System.getProperties();
            for (Object key : properties.keySet()) {
                Object value = properties.get(key);
                LOG.info("{} = {}", key, value);
            }
            LOG.info(CUtilString.LINE_CRLF);
        }
    }

    @Override
    public void handleProperty(@NotNull String aPath, @NotNull String aKey, @Nullable String aValue) {
        this.setConfigValue(EConfigurationSource.FILE, aPath, aKey, aValue);
    }

    @Override
    public void removeAllKeysFromPreferenceNode(@NotNull Preferences aNode) {
        try {
            for (String key : aNode.keys()) {
                aNode.remove(key);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public CStringProperties readProperties(@NotNull Preferences aPreferences) throws BackingStoreException {
        String[] keys;
        CStringProperties sp = new CStringProperties();
        for (String key : keys = aPreferences.keys()) {
            String value = aPreferences.get(key, "");
            sp.put(key, value);
        }
        return sp;
    }

    @Override
    @NotNull
    public CNodeAddress getNodeAddress() {
        return this.mNodeAddress;
    }

    public byte @Nullable [] getNodePreferences(@NotNull String aConfigName) {
        try {
            Preferences nodes = this.getNodesNode();
            if (nodes.nodeExists(aConfigName)) {
                Preferences pref = nodes.node(aConfigName);
                return this.exportPreferencesToByteArray(pref);
            }
        }
        catch (BackingStoreException aE) {
            LOG.error("Preference Node {} not found.", aConfigName);
        }
        return null;
    }

    @NotNull
    private String getConfigValue(@NotNull String aPath, @NotNull String aKey, boolean aUsePreferences) {
        CConfigurationEntry entry;
        if (this.mConfigurationEntryList != null && (entry = this.mConfigurationEntryList.get(aPath, aKey)) != null) {
            return entry.getValue();
        }
        if (aUsePreferences && this.isPreferencesAvailable()) {
            Preferences preferences = this.getPreferences(aPath);
            return preferences.get(aKey, "");
        }
        return "";
    }

    public void setConfigValue(@NotNull EConfigurationSource aSource, @NotNull String aPath, @NotNull String aKey, @Nullable String aValue) {
        if (this.mConfigurationEntryList != null) {
            CConfigurationEntry entry = new CConfigurationEntry(aSource, aPath, aKey, aValue);
            this.mConfigurationEntryList.add(entry);
        } else if (this.isPreferencesAvailable()) {
            Preferences preferences = this.getPreferences(aPath);
            preferences.put(aKey, aValue);
        }
    }

    private void resolveBasePath() {
        Path path;
        String baseDirString = this.getConfigValue("kernel.configuration", "base.dir", false);
        if (CUtilString.isEmpty(baseDirString)) {
            baseDirString = System.getProperty("user.dir");
        }
        if (!this.checkIfDirectory(path = Paths.get(baseDirString, new String[0]))) {
            LOG.error("No valid BaseDir");
            if (this.mTypeOfNode == ETypeOfNode.SERVER) {
                System.exit(ESystemExit.MISSING_BASE_DIR.getValue());
            } else {
                return;
            }
        }
        this.mBasePath = path;
        this.mDependencies.getNodeStringProperties().set("path.kernel.base", this.mBasePath.toString());
        LOG.info("BasePath = {}", this.mBasePath);
    }

    private void resolveLicenseId() {
        String value = this.getConfigValue("kernel.configuration", "license", true);
        this.mLicense = CUtilUuid.fromString(value);
        if (CUtilUuid.isEmpty(this.mLicense) && this.mTypeOfNode == ETypeOfNode.SERVER) {
            LOG.error("No license UUID found in Kernel Configuration.");
            LOG.error("Please provide license property, key = {}", "license");
        }
        this.mDependencies.getNodeStringProperties().set("kernel.license", this.mLicense.toString());
        LOG.info("License is {}", this.mLicense);
    }

    private void resolveTypeOfNode() {
        String s = this.getConfigValue("kernel.configuration", "type.of.node", true);
        this.mTypeOfNode = CUtilEnum.fromString(ETypeOfNode.class, s, null);
        if (this.mTypeOfNode == null) {
            LOG.error("");
        }
    }

    private void log(boolean aIsError, @NotNull String aMessage) {
        if (this.isLogAvailable()) {
            if (aIsError) {
                LOG.error(aMessage);
            } else {
                LOG.info(aMessage);
            }
        } else if (aIsError) {
            System.err.println(aMessage);
        } else {
            System.out.println(aMessage);
        }
    }

    private boolean isLogAvailable() {
        return this.mLogIsAvailable;
    }

    private void resolveNodeId() {
        String value = this.getConfigValue("kernel.configuration", "node.id", false);
        if (CUtilString.isEmpty(value)) {
            this.log(true, "Missing NodeId.");
            throw new CRuntimeError(new Error("Missing property node.id"));
        }
        if (value.contains(WILD_CARD)) {
            String s = CUtilUuid.toShortString(CUtilUuid.random());
            value = value.replace(WILD_CARD, s);
            this.setConfigValue(EConfigurationSource.CALCULATED, "kernel.configuration", "node.id", value);
        }
        CNodeId nodeId = CNodeId.fromObject(value);
        this.mNodeAddress = new CNodeAddress(nodeId);
        CNodeId.setLocal(nodeId);
        this.mConfigurationName = this.getConfigValue("kernel.configuration", "config.name", false);
        if (CUtilString.isEmpty(this.mConfigurationName)) {
            this.mConfigurationName = value;
        }
        this.setConfigValue(EConfigurationSource.CALCULATED, "kernel.configuration", "config.name", this.mConfigurationName);
        this.log(false, "Configuration Name is " + this.mConfigurationName);
        this.mKernelPreferences = this.getPreferences("kernel.configuration");
    }

    private void configureLog() throws BackingStoreException {
        String value = this.mNodeAddress.getNodeId().valueToString();
        ILogConfiguration configuration = CLoggerFactory.getConfiguration();
        configuration.readPreferences("sillysky", this.mConfigurationName);
        this.mLogIsAvailable = true;
        this.mKernelPreferences.put("node.id", value);
        LOG.info("NodeId is {}", value);
    }

    private Path resolvePath(String aKey, String aDefault) {
        LOG.trace("Resolve Path: Key={}, Default={}", aKey, aDefault);
        String optionalBaseDir = this.mBasePath.toString();
        String value = this.getConfigValue("kernel.configuration", aKey, false);
        if (CUtilString.isValid(value)) {
            return CUtilPath.resolvePath(optionalBaseDir, value);
        }
        return CUtilPath.resolvePath(optionalBaseDir, aDefault);
    }

    private void resolveSegmentId() {
        String text;
        CSegmentId segmentId;
        String value = this.getConfigValue("kernel.configuration", "segment.id", true);
        if (CUtilString.isEmpty(value)) {
            segmentId = new CSegmentId(CUtilUuid.random());
            text = "No segment ID found. Take a random one. ";
        } else if (value.contains(WILD_CARD)) {
            String s = CUtilUuid.toShortString(CUtilUuid.random());
            value = value.replace(WILD_CARD, s);
            segmentId = new CSegmentId(value);
            text = "Wildcard '*' found. This is a client node. ";
            this.mTypeOfNode = ETypeOfNode.CLIENT;
        } else {
            segmentId = new CSegmentId(value);
            text = "";
        }
        value = segmentId.valueToString();
        this.log(false, text + "SegmentId = " + value);
        this.mNodeAddress = new CNodeAddress(this.mNodeAddress.getNodeId(), segmentId);
        CSegmentId.setLocal(segmentId);
        this.setConfigValue(EConfigurationSource.CALCULATED, "kernel.configuration", "segment.id", value);
    }

    private void resolveStorageDirectory() {
        String configValue = this.getConfigValue("kernel.configuration", "no.storage.dir", true);
        boolean doNotUseStoragePath = CUtilBoolean.fromString(configValue);
        if (!doNotUseStoragePath) {
            Path storagePath = this.resolvePath("storage.dir", "storage");
            this.createDirectory(storagePath);
            String value = storagePath.toString();
            this.log(false, "Storage Path is: " + value);
            this.mKernelPreferences.put("storage.dir", value);
            this.mDependencies.getNodeStringProperties().set("path.storage", storagePath.toString());
            this.mStoragePath = storagePath;
        }
    }

    private void takeOverConfigProperties() throws BackingStoreException {
        if (this.mConfigurationEntryList != null) {
            for (String key : this.mConfigurationEntryList.keySet()) {
                CConfigurationEntry entry = this.mConfigurationEntryList.get(key);
                Preferences preferences = this.getPreferences(entry.getPath());
                preferences.put(entry.getKey(), entry.getValue());
            }
            this.getUserRoot().flush();
            this.mConfigurationEntryList = null;
        }
    }

    private void readEnvironmentVariables() {
        for (String key : this.mEnvironment.keySet()) {
            String path;
            String key3;
            if (!key.startsWith("NY_")) continue;
            String key2 = key.substring("NY_".length()).replace("___", PREFERENCE_DELIMITER).replace("__", ".").toLowerCase();
            int index = key2.lastIndexOf(47);
            if (index < 0) {
                key3 = key2;
                path = "kernel.configuration";
            } else {
                key3 = key2.substring(index + 1);
                path = key2.substring(0, index);
            }
            String normalizedKey = CUtilNormalize.normalizePreference(key3);
            String value = this.mEnvironment.get(key);
            this.mConfigurationEntryList.add(new CConfigurationEntry(EConfigurationSource.ENVIRONMENT, path, normalizedKey, value));
        }
    }
}

