/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.hsm;

import de.sillysky.nyssr.hsm.IHsm;
import de.sillysky.nyssr.hsm.IHsmMessageHandler;
import de.sillysky.nyssr.hsm.IHsmMessageHandlerRegistry;
import de.sillysky.nyssr.hsm.IHsmState;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.hsm.CHsmFactory;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.logger.IMessageLogger;
import de.sillysky.nyssr.record.CRecord;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class CHsmMessageHandlerRegistry
implements IHsmMessageHandlerRegistry {
    private final Map<IId, IHsmMessageHandler[]> mHandlerMap;
    private final IHsmState mState;
    private final CHsmFactory mFactory;
    private final IHsm mHsm;
    private final IMessageLogger mMessageLogger;
    private final AtomicInteger mMessageNumber = new AtomicInteger(0);
    private IHsmMessageHandler mNullMessageHandler = null;
    private boolean mVerbose = true;

    CHsmMessageHandlerRegistry(CHsmFactory aFactory, IHsm aHsm, IHsmState aState) {
        this.mFactory = aFactory;
        this.mHsm = aHsm;
        this.mState = aState;
        this.mHandlerMap = new HashMap<IId, IHsmMessageHandler[]>();
        Object owner = this.mHsm.getOwnerOrLogger();
        this.mMessageLogger = owner == null ? this.mFactory.getMessageLogger() : this.mFactory.createMessageLogger(owner);
    }

    @Override
    public final void addMessageHandler(IId aId, IHsmMessageHandler aHandler) {
        if (aId == null || !aId.isValid()) {
            this.mNullMessageHandler = aHandler;
        } else {
            IHsmMessageHandler[] handler2;
            IHsmMessageHandler[] handler1 = this.mHandlerMap.get(aId);
            if (handler1 == null) {
                handler2 = new IHsmMessageHandler[]{aHandler};
            } else {
                handler2 = new IHsmMessageHandler[handler1.length + 1];
                System.arraycopy(handler1, 0, handler2, 0, handler1.length);
                handler2[handler2.length - 1] = aHandler;
            }
            this.mHandlerMap.put(aId, handler2);
        }
    }

    private IMessageLogger getLogger(boolean aIsLogEnabled) {
        if (this.mVerbose && aIsLogEnabled && this.mMessageLogger != null && this.mMessageLogger.isTraceEnabled()) {
            return this.mMessageLogger;
        }
        return null;
    }

    @Override
    public final boolean handleMessage(IHsm aHsm, CEnvelope aEnvelope, CRecord aRecord) throws Exception {
        boolean handled = false;
        IId id = aRecord.getId();
        IHsmMessageHandler[] handler = this.mHandlerMap.get(id);
        if (handler == null) {
            if (this.mNullMessageHandler != null) {
                handled = this.handleMessage(this.mNullMessageHandler, aEnvelope, aRecord);
            } else {
                this.logNotHandled(aEnvelope, aRecord, this.mState);
            }
        } else {
            for (IHsmMessageHandler h : handler) {
                handled |= this.handleMessage(h, aEnvelope, aRecord);
            }
        }
        if (handled) {
            aEnvelope.setHandled(true);
        } else {
            aEnvelope.setResult(2001, "Not handled.");
        }
        return handled;
    }

    private boolean handleMessage(IHsmMessageHandler aHandler, CEnvelope aEnvelope, CRecord aRecord) throws Exception {
        int no = this.mMessageNumber.incrementAndGet();
        String text = this.mFactory.getNameDb().getRecordIdDatabase().getName(aRecord.getId());
        this.logBefore(text, no, aEnvelope, aRecord);
        boolean handled = aHandler.handleMessage(this.mHsm, this.mState, aEnvelope, aRecord);
        this.logAfter(aEnvelope, aRecord, handled);
        return handled;
    }

    @Override
    public final boolean isVerbose() {
        return this.mVerbose;
    }

    private void logAfter(CEnvelope aEnvelope, CRecord aRecord, boolean aHandled) {
        IMessageLogger logger = this.getLogger(aEnvelope.isLogEnabled());
        if (logger != null) {
            String string1 = logger.logAfter(aEnvelope, aRecord, aHandled);
            logger.getLogger().trace(string1);
        }
    }

    private void logBefore(String aHandlerName, int aNo, CEnvelope aEnvelope, CRecord aRecord) {
        IMessageLogger logger = this.getLogger(aEnvelope.isLogEnabled());
        if (logger != null) {
            String string1 = logger.logBefore(this.mState, aHandlerName, aEnvelope, aRecord);
            String string2 = logger.logMessage(aEnvelope, aRecord);
            logger.getLogger().trace("{} ------> {}", string1, string2);
        }
    }

    private void logNotHandled(CEnvelope aEnvelope, CRecord aRecord, IHsmState aState) {
        IMessageLogger logger = this.getLogger(aEnvelope.isLogEnabled());
        if (logger != null) {
            String string1 = logger.logNotHandled(this.mState, aEnvelope, aRecord);
            String string2 = logger.logMessage(aEnvelope, aRecord);
            logger.getLogger().trace("{} ------> {}", string1, string2);
        }
    }

    @Override
    public final void removeMessageHandler(IId aMID) {
        this.mHandlerMap.remove(aMID);
    }

    @Override
    public final void setVerbose(boolean aVerbose) {
        this.mVerbose = aVerbose;
    }
}

