/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.hsm;

import de.sillysky.nyssr.hsm.IHsm;
import de.sillysky.nyssr.hsm.IHsmFactory;
import de.sillysky.nyssr.impl.hsm.CHsm;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.logger.IMessageLogger;
import de.sillysky.nyssr.message.logger.IMessageLoggerFactory;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import org.jetbrains.annotations.NotNull;

final class CHsmFactory
implements IHsmFactory,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CHsmFactory.class);
    private INameDb mNameDb;
    private IMessageLoggerFactory mMessageLoggerFactory;
    private IMessageLogger mMessageLogger = null;

    CHsmFactory() {
    }

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IMessageLoggerFactory.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mNameDb = aServiceRegistry.getService(INameDb.class);
        this.mMessageLoggerFactory = aServiceRegistry.getService(IMessageLoggerFactory.class);
        assert (this.mMessageLoggerFactory != null);
        this.mMessageLogger = this.mMessageLoggerFactory.createLogger(this.getClass());
        aServiceRegistry.registerService(IHsmFactory.class, this);
    }

    @Override
    public IHsm create(String aName, Object aOwnerOrLogger) {
        CHsm result = new CHsm(this, aName, aOwnerOrLogger);
        LOG.info("create HSM {}.", aName);
        return result;
    }

    IMessageLogger createMessageLogger(Object aOwnerOrLogger) {
        if (this.mMessageLoggerFactory != null) {
            return this.mMessageLoggerFactory.createLogger(aOwnerOrLogger);
        }
        return null;
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService(this);
    }

    IMessageLogger getMessageLogger() {
        return this.mMessageLogger;
    }

    INameDb getNameDb() {
        return this.mNameDb;
    }
}

