/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.id.integer;

import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.IIdFactory;
import de.sillysky.nyssr.id.integer.CIdInteger;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.unique.integer.IUniqueInteger;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilInteger;
import java.io.DataInput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CIdIntegerFactory
implements IIdFactory {
    CIdIntegerFactory() {
    }

    @Override
    @Nullable
    public IId fromObject(@Nullable Object aObj) {
        if (aObj != null) {
            int value = 0;
            if (aObj instanceof Integer) {
                value = (Integer)aObj;
            } else if (aObj instanceof Short) {
                value = ((Short)aObj).intValue();
            } else if (aObj instanceof Long) {
                value = ((Long)aObj).intValue();
            } else if (aObj instanceof Byte) {
                value = ((Byte)aObj).intValue();
            } else if (aObj instanceof Character) {
                char c = ((Character)aObj).charValue();
                if (Character.isDigit(c)) {
                    value = Character.getNumericValue(c);
                }
            } else if (aObj instanceof String) {
                String s = (String)aObj;
                value = CUtilInteger.fromString(s);
            }
            if (value != 0) {
                return new CIdInteger(value);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public IId random() {
        IUniqueInteger ui;
        int id;
        do {
            ui = CServiceRegistry.getInstance().getService(IUniqueInteger.class);
            assert (ui != null);
        } while ((id = ui.getNext("IntId")) == 0);
        return new CIdInteger(id);
    }

    @Override
    @NotNull
    public IId fromStream(@NotNull DataInput aStream) throws IOException {
        int id = CPositiveInteger.fromStream(aStream);
        if (id == 0) {
            return IId.INVALID;
        }
        return new CIdInteger(id);
    }

    @Override
    @NotNull
    public EIdType getType() {
        return EIdType.INT;
    }
}

