/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilObjectArray;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilStringArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilNodeAddressArray {
    public static final CNodeAddress[] EMPTY = new CNodeAddress[0];

    private CUtilNodeAddressArray() {
    }

    public static CNodeAddress @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        CNodeAddress[] value = new CNodeAddress[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            value[i] = CNodeAddress.fromStream(aStream);
        }
        return value;
    }

    @Nullable
    public static CNodeAddress[] fromString(@Nullable String aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return null;
        }
        String[] result = CUtilStringArray.fromString(aValue);
        if (result == null || result.length == 0) {
            return null;
        }
        CNodeAddress[] value = new CNodeAddress[result.length];
        for (int i = 0; i < result.length; ++i) {
            value[i] = CNodeAddress.fromString(result[i]);
        }
        return value;
    }

    public static void toStream(@NotNull DataOutput aStream, CNodeAddress @Nullable [] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (CNodeAddress element : aValue) {
                CNodeAddress.toStream(aStream, element);
            }
        }
    }

    @NotNull
    public static String toString(CNodeAddress @Nullable [] aValue) {
        return CUtilObjectArray.toString((Object[])aValue, 100);
    }

    @NotNull
    public static String valueToString(CNodeAddress @Nullable [] aValue) {
        if (aValue == null || aValue.length == 0) {
            return "";
        }
        String[] arr = new String[aValue.length];
        for (int i = 0; i < aValue.length; ++i) {
            arr[i] = aValue[i] == null ? "" : aValue[i].valueToString();
        }
        return CUtilStringArray.toStringWithPipe(arr);
    }

    public static CNodeAddress @NotNull [] random(int aSize, boolean aWithNullValues) {
        CNodeAddress[] arr = new CNodeAddress[aSize];
        for (int i = 0; i < aSize; ++i) {
            boolean b = CUtilRandom.getRandom().nextBoolean();
            if (!b && aWithNullValues) continue;
            arr[i] = CNodeAddress.random();
        }
        return arr;
    }

    public static boolean isEqual(CNodeAddress @Nullable [] aValue1, CNodeAddress @Nullable [] aValue2) {
        if (aValue1 == null) {
            return aValue2 == null;
        }
        if (aValue2 == null) {
            return false;
        }
        for (int i = 0; i < aValue1.length; ++i) {
            if (CNodeAddress.isEqual(aValue1[i], aValue2[i])) continue;
            return false;
        }
        return true;
    }

    public static CNodeAddress @Nullable [] copy(CNodeAddress @Nullable [] aValue) {
        if (aValue == null) {
            return null;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }
}

