/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.factory.collector;

import de.sillysky.nyssr.app.factory.collector.records.CRecordGetApplicationListForUser;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationFactoryList;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

class CTargetGetApplicationList
extends CTarget {
    private final CEnvelope mEnvelope;
    private final CRecord mRecord;
    private final CApplicationFactoryList mFactories;

    CTargetGetApplicationList(@NotNull CApplicationFactoryList aFactories, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mFactories = aFactories;
        this.mEnvelope = aEnvelope;
        this.mRecord = aRecord;
        this.mEnvelope.setBlocked(true);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncSessionValidate);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        byte[] sessionToken = this.mEnvelope.getSessionToken();
        if (sessionToken == null) {
            this.sendBack(8, "Missing session token");
        } else {
            this.sendGetPermissions(sessionToken);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String text = "";
            int resultCode = aEnvelope.getResultCode();
            switch (resultCode) {
                case 0: {
                    String[] rights = CRecordSessionValidate.getRights((CRecord)aRecord, null);
                    String platform = CRecordGetApplicationListForUser.getPlatform((CRecord)this.mRecord, (String)"");
                    try {
                        CRecord[] apps = this.mFactories.getApplicationListForPermission(rights, platform);
                        CRecordGetApplicationListForUser.setApplicationList((CRecord)this.mRecord, (CRecord[])apps);
                    }
                    catch (CException aE) {
                        resultCode = aE.getCode();
                        text = aE.getMessage();
                    }
                    break;
                }
                case 2001: {
                    resultCode = 5102;
                    text = "Can't validate Token";
                    break;
                }
                default: {
                    text = aEnvelope.getResultText();
                }
            }
            this.sendBack(resultCode, text);
            return true;
        }
        return false;
    }

    private void sendGetPermissions(byte[] aSessionToken) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        env.setSessionToken(aSessionToken);
        CRecord record = CRecordSessionValidate.create();
        this.sendRequest(env, record);
    }

    private void sendBack(int aCode, @NotNull String aText) throws CException {
        this.mEnvelope.setResult(aCode, aText);
        this.mEnvelope.setBlocked(false);
        this.getMessageSender().sendBack(this.mEnvelope, this.mRecord);
        this.deregisterTarget();
    }
}

