/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.configuration.provider;

import de.sillysky.nyssr.impl.configuration.provider.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilFile;
import de.sillysky.nyssr.util.tcp.CTcpConnection;
import de.sillysky.nyssr.util.tcp.CTcpServer;
import de.sillysky.nyssr.util.tcp.ITcpOwner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

class CConfigurationProvider
implements IService,
ITcpOwner {
    private static final ILogger LOG = CLoggerFactory.getLogger(CConfigurationProvider.class);
    private final IDependencies mDependencies;
    private CTcpServer mServer;

    CConfigurationProvider(IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        Preferences preferences = kc.getPreferences("network/configuration.provider");
        String s = preferences.get("server.port", null);
        int port = CUtilInteger.fromString((String)s, (int)28346);
        s = preferences.get("connection.input.buffer.size", null);
        int bufSize = CUtilInteger.fromString((String)s, (int)2100);
        this.mServer = new CTcpServer((ITcpOwner)this, port, bufSize);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mServer.close();
    }

    public void notifyInput(Object aDataProvider, byte[] aBytes) {
        CTcpConnection connection = (CTcpConnection)aDataProvider;
        String configName = new String(aBytes, StandardCharsets.UTF_8);
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        Path storagePath = kc.getStoragePath();
        if (storagePath == null) {
            LOG.error("No storage path");
        } else {
            Path path = storagePath.resolve("ConfigurationProvider");
            path = path.resolve(configName + ".xml");
            File file = path.toFile();
            String xmlString = null;
            if (file.exists()) {
                try {
                    xmlString = CUtilFile.readTextFile((Path)path, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException aE) {
                    LOG.error((Throwable)aE, "Error reading configuration for {}", new Object[]{configName});
                }
            }
            if (CUtilString.isValid(xmlString)) {
                byte[] xml = xmlString.getBytes(StandardCharsets.UTF_8);
                try {
                    connection.send(xml);
                }
                catch (Exception aE) {
                    LOG.error((Throwable)aE, "Error sending configuration for {}", new Object[]{configName});
                }
            }
        }
        connection.close();
    }

    public void notifyOpened(@NotNull CTcpConnection aConnection) {
        LOG.info("{}: Server opened", new Object[]{"ConfigurationProvider"});
    }

    public void notifyClosed(@NotNull CTcpConnection aConnection) {
        this.mServer.notifyClosed(aConnection);
    }

    @NotNull
    public String getName() {
        return "ConfigurationProvider";
    }
}

