/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.context.target;

import de.sillysky.nyssr.cli.records.CRecordCliAddHandler;
import de.sillysky.nyssr.cli.records.CRecordCliHandle;
import de.sillysky.nyssr.cli.records.CRecordCliRemoveHandler;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreRequestFile;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.remoteskin.client.context.target.CFileEntry;
import de.sillysky.nyssr.impl.remoteskin.client.context.target.CFileEntryList;
import de.sillysky.nyssr.impl.remoteskin.client.context.target.CFileRequester;
import de.sillysky.nyssr.impl.remoteskin.client.context.target.IPrivateDependencies;
import de.sillysky.nyssr.impl.remoteskin.client.context.target.IRemoteSkinClientContextTarget;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.model.EFileDeliveryType;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.model.records.CRecordRemoteSkinApplyAttributes;
import de.sillysky.nyssr.remoteskin.server.records.CRecordRemoteSkinStoreWidgetSets;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.signal.properties.IPropertySignal;
import de.sillysky.nyssr.signal.properties.IPropertySignalDispatcher;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.io.File;
import java.util.List;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CRemoteSkinClientContextTarget
extends CTarget
implements IRemoteSkinClientContextTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRemoteSkinClientContextTarget.class);
    private static final String CLI_LIST_WIDGET_SETS = "lws";
    private static final String CLI_HELP_LWS = "List widget sets";
    private final CFileEntryList mFileRequests = new CFileEntryList();
    private IRemoteSkinClientContext mContext;
    private IPrivateDependencies mDependencies;

    CRemoteSkinClientContextTarget() {
    }

    void activate(@NotNull IPrivateDependencies aDependencies, @NotNull IRemoteSkinClientContext aContext, @NotNull ITargetRegistry aTargetRegistry) throws Exception {
        this.mContext = aContext;
        this.mContext.setTarget((ITarget)this);
        this.mDependencies = aDependencies;
        IPropertySignalDispatcher sd = this.mDependencies.getSystemSignalDispatcher();
        sd.addListener(CUtilUuid.fromString((String)"c467035d-5c9b-4337-a5a8-b0826f104696"), this::syncGetFile, false);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordRemoteSkinStoreWidgetSets.ID, this::asyncStoreWidgetSets);
        this.addMessageHandler(CRecordRemoteSkinApplyAttributes.ID, this::asyncApplyAttributes);
        this.addMessageHandler(CRecordFileStoreRequestFile.ID, this::asyncLfsGetFile);
        this.addMessageHandler(CRecordCliHandle.ID, this::asyncCliHandle);
        this.addMessageHandler(null, this::asyncAll);
        aTargetRegistry.registerTarget((ITarget)this);
    }

    private void syncGetFile(IPropertySignal aSignal) {
        UUID transactionId;
        CWidgetId wid = (CWidgetId)aSignal.getObject("WidgetId", null);
        String path = aSignal.getString("Path", null);
        Object token = aSignal.getObject("Token", null);
        String fileDeliveryType = aSignal.getString("FileDeliveryType", EFileDeliveryType.AS_FILE.name());
        if (wid != null && path != null && (transactionId = this.mFileRequests.add(path, wid, token, fileDeliveryType)) != null) {
            try {
                CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
                env.setTransactionId(transactionId);
                CRecord rec = CRecordFileStoreRequestFile.create();
                CRecordFileStoreRequestFile.setPath((CRecord)rec, (String)path);
                if (EFileDeliveryType.AS_FILE.name().equals(fileDeliveryType)) {
                    CRecordFileStoreRequestFile.setDeliveryType((CRecord)rec, (byte)de.sillysky.nyssr.file.store.api.EFileDeliveryType.FILE.getType());
                } else {
                    CRecordFileStoreRequestFile.setDeliveryType((CRecord)rec, (byte)de.sillysky.nyssr.file.store.api.EFileDeliveryType.BYTES.getType());
                }
                this.sendRequest(env, rec);
            }
            catch (CException aE) {
                LOG.error((Throwable)aE, "Couldn't send GetFile");
            }
        }
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.addCommandLineHandler();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncApplyAttributes(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String json = CRecordRemoteSkinApplyAttributes.getJson((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)json, (String)"Json is empty", (Object[])new Object[0]);
        SwingUtilities.invokeLater(() -> {
            try {
                this.mContext.applyAttributes(aEnvelope.getSender(), json);
            }
            catch (CException aE) {
                LOG.error((Throwable)aE, "Error applying attributes");
            }
        });
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncLfsGetFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            if (result.isSuccess()) {
                UUID transactionId = aEnvelope.getTransactionId();
                CFileEntry entry = this.mFileRequests.remove(transactionId);
                if (entry == null) {
                    LOG.error("No FileRequestEntry found");
                } else {
                    byte[] bytes = CRecordFileStoreRequestFile.getBytes((CRecord)aRecord, null);
                    File file = (File)CRecordFileStoreRequestFile.getFile((CRecord)aRecord, null);
                    this.informRequestersGetFile(entry, file, bytes);
                }
            }
            return true;
        }
        return false;
    }

    private boolean asyncAll(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        return this.mContext.getPlatformContext().handleMessage((ITarget)this, aEnvelope, aRecord);
    }

    private boolean asyncStoreWidgetSets(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        String[] widgetSets;
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String widgetSet = CRecordRemoteSkinStoreWidgetSets.getWidgetSet((CRecord)aRecord, null);
        if (widgetSet != null) {
            this.mContext.storeWidgetSet(widgetSet);
            aRecord.removeSlot("ws");
        }
        if ((widgetSets = CRecordRemoteSkinStoreWidgetSets.getWidgetSets((CRecord)aRecord, null)) != null) {
            for (String json : widgetSets) {
                this.mContext.storeWidgetSet(json);
            }
            aRecord.removeSlot("wsArr");
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncCliHandle(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String command = CRecordCliHandle.getCommand((CRecord)aRecord, (String)"");
        if (CLI_LIST_WIDGET_SETS.equals(command)) {
            String[] args = CRecordCliHandle.getArguments((CRecord)aRecord, null);
            String filter = "";
            if (args != null && args.length >= 1 && args[0] != null) {
                filter = CUtilString.fromObject((Object)args[0], (String)"");
            }
            this.mContext.dumpWidgetSets(filter);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        IPropertySignalDispatcher sd = this.mDependencies.getSystemSignalDispatcher();
        sd.removeListener(this::syncGetFile);
        this.removeCommandLineHandler();
        this.deregisterTarget();
    }

    private void informRequestersGetFile(@NotNull CFileEntry aEntry, @Nullable File aFile, byte[] aBytes) {
        List<CFileRequester> requesters = aEntry.getRequesters();
        for (CFileRequester req : requesters) {
            String fileDeliveryType = req.getFileDeliveryType();
            if (aFile != null) {
                this.mContext.fileArrived(req.getWidgetId(), aEntry.getRelativePath(), req.getToken(), aFile);
                continue;
            }
            if (aBytes == null) continue;
            if (EFileDeliveryType.AS_IMAGE.name().equals(fileDeliveryType)) {
                ImageIcon image = new ImageIcon(aBytes);
                this.mContext.fileArrived(req.getWidgetId(), aEntry.getRelativePath(), req.getToken(), image);
                continue;
            }
            this.mContext.fileArrived(req.getWidgetId(), aEntry.getRelativePath(), req.getToken(), aBytes);
        }
    }

    private void addCommandLineHandler() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordCliAddHandler.create();
        CRecordCliAddHandler.setCommand((CRecord)record, (String[])new String[]{CLI_LIST_WIDGET_SETS});
        CRecordCliAddHandler.setHelp((CRecord)record, (String[])new String[]{CLI_HELP_LWS});
        this.sendNotification(env, record);
    }

    private void removeCommandLineHandler() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordCliRemoveHandler.create();
        CRecordCliRemoveHandler.setCommand((CRecord)record, (String)CLI_HELP_LWS);
        this.sendNotification(env, record);
    }
}

