/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.router.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkGetListOfReachableNodes
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"7813b62b-6564-4e9d-89b9-4a61fee620e2");
    public static final String NAME = "NetworkGetListOfReachableNodes";
    public static final String DESCRIPTION = "Get a list of reachable nodes.";
    public static final String SLOT_NODES = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CNodeAddress[] getNodes(@NotNull CRecord aRecord, CNodeAddress[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODES);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress[])slot.getValue();
    }

    public static void setNodes(@NotNull CRecord aRecord, CNodeAddress[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_NODES, slot);
    }
}

