/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkGetConnection
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"01c6549a-88a7-4558-81cf-03dbc6fa7caa");
    public static final String NAME = "NetworkGetConnection";
    public static final String DESCRIPTION = "Get a connection from the connection registry.";
    public static final String SLOT_CONNECTION = "2";
    public static final String SLOT_CONNECTION_ID = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CRecord getConnection(@NotNull CRecord aRecord, CRecord aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CONNECTION);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord)slot.getValue();
    }

    public static UUID getConnectionId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CONNECTION_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static void setConnection(@NotNull CRecord aRecord, CRecord aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD, (Object)aValue);
        aRecord.addSlot(SLOT_CONNECTION, slot);
    }

    public static void setConnectionId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_CONNECTION_ID, slot);
    }
}

