/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase.textfield;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.app.widget.showcase.textfield.CTextFieldModel;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventCaretNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventInteger;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventColorChooserDialogNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowColorChooserDialog;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ICaretListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IColorChooserListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IIntegerListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class CTextFieldUi {
    private final CTextFieldModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs311;
    private CWidgetId m311PanelMain;
    private CWidgetId m311Component002;
    private CWidgetId m311Button002;
    private CWidgetId m311Component003;
    private CWidgetId m311Spinner003;
    private int mCaretPosition003 = 0;

    public CTextFieldUi(@NotNull CTextFieldModel aModel) {
        this.mModel = aModel;
        this.mServerContext = aModel.getAppContext().getRemoteSkinServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        String instance = this.mModel.getParent().getWidgetSetId().getInstance();
        this.mWs311 = CWidgetSetId.create((String)"@311_TextField", (String)instance);
    }

    private void widgetSet311Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        this.m311PanelMain = CWidgetId.create((String)"#311_Panel", (CWidgetSetId)this.mWs311);
        this.mApi.setVisible(this.m311PanelMain, true);
        this.m311Component002 = CWidgetId.create((String)"#311_Component_002", (CWidgetSetId)this.mWs311);
        this.m311Button002 = CWidgetId.create((String)"#311_Helper_002", (CWidgetSetId)this.mWs311);
        this.mApi.addListener(this.m311Button002, (IListener)((IButtonPressedListener)this::onButton002));
        this.mApi.addListener(this.m311Button002, (IListener)((IColorChooserListener)this::onColorChooser002));
        this.m311Component003 = CWidgetId.create((String)"#311_Component_003", (CWidgetSetId)this.mWs311);
        this.mApi.addListener(this.m311Component003, (IListener)((ITextChangeListener)this::onTextFieldChanged003));
        this.mApi.addListener(this.m311Component003, (IListener)((ICaretListener)this::onCaretChanged003));
        this.m311Spinner003 = CWidgetId.create((String)"#311_Helper_003", (CWidgetSetId)this.mWs311);
        this.mApi.addListener(this.m311Spinner003, (IListener)((IIntegerListener)this::onSpinnerChanged003));
        this.mServerContext.sendUpdate();
        this.mModel.getAppContext().sendOtherWidgetSets();
    }

    private void onColorChooser002(CEventColorChooserDialogNotification aEvent) {
        CEventColor eventColor = aEvent.getColor();
        if (eventColor != null) {
            this.mApi.setBackgroundColor(this.m311Button002, eventColor);
            this.mApi.setCaretColor(this.m311Component002, eventColor);
            this.mServerContext.sendUpdate();
        }
    }

    private void onButton002(@NotNull CEventButtonPressedNotification aEvent) {
        CEventShowColorChooserDialog event = new CEventShowColorChooserDialog(false, "Caret Color", new CEventColor(Color.red), new CEventWidgetId(this.m311Button002));
        this.mApi.showColorChooserDialog(this.m311Button002, event);
        this.mServerContext.sendUpdate();
    }

    private void onCaretChanged003(@NotNull CEventCaretNotification aEvent) {
        int pos = aEvent.getDot();
        if (pos != this.mCaretPosition003) {
            this.mCaretPosition003 = pos;
            this.mApi.setValue(this.m311Spinner003, this.mCaretPosition003);
            this.mServerContext.sendUpdate();
        }
    }

    private void onSpinnerChanged003(@NotNull CEventInteger aEvent) {
        this.mCaretPosition003 = aEvent.getValue();
        if (this.mCaretPosition003 >= 0) {
            this.mApi.setCaretPosition(this.m311Component003, this.mCaretPosition003);
            this.mServerContext.sendUpdate();
        }
    }

    private void onTextFieldChanged003(@NotNull CEventTextChangeNotification aEvent) {
        String text = aEvent.getText();
        int max = text.length();
        this.mApi.setMaximum(this.m311Spinner003, max);
        this.mServerContext.sendUpdate();
    }

    void mountWidgetSet311() {
        this.mServerContext.mountWidgetSet(this.mWs311, this.mModel.getParent(), "#311_Panel", this::widgetSet311Mounted);
        this.mServerContext.sendUpdate();
    }

    public void dismiss() {
        this.mApi.unmount(this.m311PanelMain);
    }
}

