/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.panel;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.message.panel.CMessagePanelInstanceModel;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventListContent;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IKeyPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IMouseListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class CMessagePanelInstanceUi {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"dialog.messagepanel");
    private final IWidgetApi mApi;
    private final CMessagePanelInstanceModel mModel;
    private final boolean mScrollDirectionDown;
    private final CWidgetSetId mWs400;
    private final CWidgetId mLabelMessageHistory;
    private final CWidgetSetId mWs401;
    private final CWidgetId mDialogHistory;
    private final CWidgetId mIdHistoryList;

    CMessagePanelInstanceUi(@NotNull CMessagePanelInstanceModel aModel) {
        this.mModel = aModel;
        this.mScrollDirectionDown = this.mModel.getPreferences().getBoolean("scroll.direction", true);
        this.mApi = this.mModel.getDialogDto().getServerContext().getWidgetApi();
        String instance = this.mModel.getNextInstance();
        this.mWs400 = CWidgetSetId.create((String)"@400_MessagePanel", (String)instance);
        this.mLabelMessageHistory = CWidgetId.create((String)"#400_Label_Message", (CWidgetSetId)this.mWs400);
        this.mApi.addListener(this.mLabelMessageHistory, (IListener)((IMouseListener)ev -> this.showHistory()));
        this.mWs401 = CWidgetSetId.create((String)"@401_MsgHistoryDialog", (String)instance);
        this.mDialogHistory = CWidgetId.create((String)"#401_Dialog", (CWidgetSetId)this.mWs401);
        this.mApi.addListener(this.mDialogHistory, (IListener)((IWindowClosingListener)aEvent -> this.sendCloseDialog()));
        this.mIdHistoryList = CWidgetId.create((String)"#401_List", (CWidgetSetId)this.mWs401);
        this.mApi.addListener(this.mIdHistoryList, (IListener)((IKeyPressedListener)aEvent -> {
            if (aEvent.getCode() == 27) {
                this.sendCloseDialog();
            }
        }));
    }

    private void mountWidgetSet401() {
        IRemoteSkinServerContext serverContext = this.mModel.getDialogDto().getServerContext();
        serverContext.mountWidgetSet(this.mWs401, this.mLabelMessageHistory, null, this::widgetSet401Mounted);
        serverContext.sendUpdate();
    }

    private void widgetSet401Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mWs401.equals((Object)aWidgetSetId)) {
            this.sendListData();
            this.mApi.pack(this.mDialogHistory);
            CWidgetId centerAbove = this.mModel.getCenterAbove();
            if (centerAbove == null) {
                centerAbove = this.mModel.getParentWidgetId();
            }
            this.mApi.centerWidget(this.mDialogHistory, centerAbove);
            this.mApi.setVisible(this.mDialogHistory, true);
            this.mModel.getDialogDto().getServerContext().sendUpdate();
        }
    }

    void sendCloseDialog() {
        IRemoteSkinServerContext serverContext = this.mModel.getDialogDto().getServerContext();
        serverContext.unmountWidget(this.mDialogHistory);
        serverContext.sendUpdate();
        this.mModel.setHistoryVisible(false);
    }

    void sendListData() {
        CEventListContent event = new CEventListContent();
        ArrayList<String> list = new ArrayList<String>(this.mModel.getMessageHistory());
        Collections.reverse(list);
        for (String s : list) {
            CEventLabelItem item = new CEventLabelItem(s);
            item.getAttributes().setValue((Object)s);
            event.add(item);
        }
        this.mModel.getDialogDto().getServerContext().getWidgetApi().setListContent(this.mIdHistoryList, event);
    }

    private void updateLabel(String aText) {
        this.mApi.setText(this.mLabelMessageHistory, aText);
        this.mModel.getDialogDto().getServerContext().sendUpdate();
    }

    void sendUpdate() {
        this.mModel.getDialogDto().getServerContext().sendUpdate();
    }

    void mountWidgetSet400() {
        if (this.mModel.getPanelType() == 400) {
            this.mModel.getDialogDto().getServerContext().mountWidgetSet(this.mWs400, this.mModel.getParentWidgetId(), "#400_Label_Message", this::notify400mounted);
            this.mModel.getDialogDto().getServerContext().sendUpdate();
        }
    }

    void showHistory() {
        if (!this.mModel.isHistoryVisible()) {
            this.mountWidgetSet401();
            this.mModel.setHistoryVisible(true);
        }
    }

    private void update() {
        List<String> displayedText = this.mModel.getDisplayedText();
        StringBuilder sb = new StringBuilder();
        int rows = this.mModel.getRows();
        for (int i = 0; i < rows; ++i) {
            String text = this.mScrollDirectionDown ? displayedText.get(rows - 1 - i) : displayedText.get(i);
            if (i > 0) {
                sb.append(CUtilString.CRLF);
            }
            sb.append(text);
        }
        this.updateLabel(sb.toString());
    }

    void clear() {
        this.mModel.getMessageHistory().clear();
        this.mModel.getDisplayedText().clear();
        this.update();
    }

    void notifyMessageAdded() {
        this.update();
        if (this.mModel.isHistoryVisible()) {
            this.sendListData();
            this.sendUpdate();
        }
    }

    private void notify400mounted(@NotNull CWidgetSetId aWidgetSetId) {
        Color foreground;
        Color background = this.mModel.getBackground();
        boolean send = false;
        if (background != null) {
            this.mApi.setBackgroundColor(this.mLabelMessageHistory, new CEventColor(background));
            send = true;
        }
        if ((foreground = this.mModel.getForeground()) != null) {
            this.mApi.setForegroundColor(this.mLabelMessageHistory, new CEventColor(foreground));
            send = true;
        }
        if (send) {
            this.mModel.getDialogDto().getServerContext().sendUpdate();
        }
    }
}

