/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.user;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.dialog.user.CUtilUserDialog;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CButtonAndRight {
    private final Map<CWidgetId, Boolean> mWidgets = new HashMap<CWidgetId, Boolean>();
    private final IWidgetApi mApi;
    private String[] mSessionRights;
    private String mSessionUserId;

    CButtonAndRight(@NotNull String[] aSessionRights, @NotNull String aSessionUserId, @NotNull IWidgetApi aApi) {
        this.mSessionRights = aSessionRights;
        this.mSessionUserId = aSessionUserId;
        this.mApi = aApi;
    }

    void add(@NotNull CWidgetId aWidget) {
        this.mWidgets.put(aWidget, false);
    }

    void addAll(CWidgetId ... aWidgets) {
        for (CWidgetId widget : aWidgets) {
            this.mWidgets.put(widget, false);
        }
    }

    void check(@Nullable Object aMustNotNull, @Nullable String aUserId, @NotNull CWidgetId aWidget, @NotNull String aRight) {
        boolean isEnabled;
        boolean hasRight = CUtilUserDialog.hasRight(this.mSessionRights, aRight);
        boolean isCurrentUser = this.mSessionUserId.equals(aUserId);
        boolean enabled = aMustNotNull == null ? false : hasRight || isCurrentUser;
        Boolean o = this.mWidgets.get(aWidget);
        boolean bl = isEnabled = o != null ? o : false;
        if (enabled != isEnabled) {
            this.mWidgets.put(aWidget, enabled);
            this.mApi.setEnabled(aWidget, enabled);
        }
    }

    public void setSessionData(@NotNull String aSessionUserId, @NotNull String[] aSessionRights) {
        this.mSessionUserId = aSessionUserId;
        this.mSessionRights = aSessionRights;
    }
}

