/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.db;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.db.EAccess;
import de.sillysky.nyssr.record.db.IRecordEntry;
import de.sillysky.nyssr.record.db.ISlotRecord;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public final class CRecordEntry
implements IRecordEntry,
Comparable<CRecordEntry> {
    private static final String ALL = CWellKnownNID.ALL.toString();
    @NotNull
    private final IId mId;
    private final boolean mIsService;
    @NotNull
    private final Set<String> mNamespaces;
    @NotNull
    private final EAccess mAccessType;
    @NotNull
    private final String mName;
    @NotNull
    private final Map<String, ISlotRecord> mSlots = new HashMap<String, ISlotRecord>();
    private String mCamelCaseName;
    @NotNull
    private String mDescription = "";
    private String mFileName;
    private boolean mHasOtherSlots;

    public CRecordEntry(@NotNull String aId, @NotNull String aName, boolean aIsService, @NotNull EAccess aAccess) {
        this.mNamespaces = new HashSet<String>();
        this.mId = CIdFactory.fromObject((Object)aId);
        this.mName = aName;
        this.mIsService = aIsService;
        this.mAccessType = aAccess;
        this.makeFilename();
    }

    public void addNamespace(String aNamespace) {
        this.mNamespaces.add(aNamespace);
    }

    @Override
    public void addSlot(@NotNull ISlotRecord aSlot) {
        this.mSlots.put(aSlot.getKey(), aSlot);
    }

    @Override
    public int compareTo(CRecordEntry aOther) {
        return this.getName().compareTo(aOther.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CRecordEntry other = (CRecordEntry)obj;
        return this.mId.equals((Object)other.mId);
    }

    @Override
    public boolean forNamespace(@NotNull IId aNID) {
        if (this.mNamespaces.contains(ALL)) {
            return true;
        }
        String nid = aNID.toString();
        return this.mNamespaces.contains(nid);
    }

    @Override
    @NotNull
    public EAccess getAccessType() {
        return this.mAccessType;
    }

    @Override
    @NotNull
    public String getCamelCaseName() {
        return this.mCamelCaseName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public void setDescription(@NotNull String aDescription) {
        this.mDescription = aDescription;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.mFileName;
    }

    @Override
    @NotNull
    public IId getId() {
        return this.mId;
    }

    @Override
    @NotNull
    public String getName() {
        return this.mName;
    }

    @Override
    @NotNull
    public Collection<String> getNamespaces() {
        return Collections.unmodifiableSet(this.mNamespaces);
    }

    @Override
    public ISlotRecord getSlot(@NotNull String aKey) {
        return this.mSlots.get(aKey);
    }

    @Override
    public int getSlotCount() {
        return this.mSlots.size();
    }

    @Override
    public String getSlotName(@NotNull String aKey) {
        ISlotRecord s = this.getSlot(aKey);
        if (s != null) {
            return s.getName();
        }
        return aKey;
    }

    @Override
    @NotNull
    public Iterator<ISlotRecord> getSlots() {
        TreeSet<ISlotRecord> set = new TreeSet<ISlotRecord>(this.mSlots.values());
        return Collections.unmodifiableSet(set).iterator();
    }

    @Override
    public boolean hasOtherSlots() {
        return this.mHasOtherSlots;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mId.hashCode();
        return result;
    }

    @Override
    public boolean isNanoService() {
        return this.mIsService;
    }

    private void makeFilename() {
        StringBuilder sb = new StringBuilder(200);
        String n = this.mName.toLowerCase();
        for (int i = 0; i < n.length(); ++i) {
            char c = n.charAt(i);
            if (i == 0) {
                c = Character.toUpperCase(c);
                sb.append(c);
                continue;
            }
            if (c == '_' && i < n.length() - 1) {
                c = n.charAt(++i);
                c = Character.toUpperCase(c);
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        this.mCamelCaseName = sb.toString();
        sb.setLength(0);
        sb.append("CRecord");
        sb.append(this.mCamelCaseName);
        this.mFileName = sb.toString();
    }

    @Override
    public void setHasOtherSlots(boolean aHas) {
        this.mHasOtherSlots = aHas;
    }

    public String toString() {
        return "Record " + this.mName;
    }
}

