/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.transport;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.network.ping.ILinkCostTargetFactory;
import de.sillysky.nyssr.impl.network.transport.CTransport;
import de.sillysky.nyssr.impl.network.transport.ITransport;
import de.sillysky.nyssr.impl.network.transport.ITransportDependencies;
import de.sillysky.nyssr.impl.network.transport.ITransportFactory;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.microservice.collector.IMicroServiceRegistryCollector;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.network.connection.dto.CConnectionDto;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.network.packets.IPacketConsumerRegistry;
import de.sillysky.nyssr.network.packets.IPacketFactoryRegistry;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.timer.ITimerManager;
import org.jetbrains.annotations.NotNull;

public class CTransportFactory
implements IService,
ITransportFactory,
ITransportDependencies {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTransportFactory.class);
    private static final String TRANSPORT = "Transport";
    private INameDb mNameDb;
    private IKernelConfiguration mKernelConfiguration;
    private ITimerManager mTimerManager;
    private IMessageSender mMessageSender;
    private INamespaceFactory mNamespaceFactory;
    private IRouter mRouter;
    private INodeInfoDatabase mNodeInfoDatabase;
    private IPacketFactoryRegistry mCentralPacketFactory;
    private IPacketConsumerRegistry mCentralPacketUtility;
    private ILinkCostTargetFactory mLinkCostTargetFactory;
    private IMicroServiceRegistryCollector mMicroServiceRegistryCollector;

    @Override
    public ITransport createTransport(@NotNull CTargetAddress aOwner, @NotNull CConnectionDto aConnection) throws CException {
        LOG.debug("Create Transport");
        CTransport t = new CTransport();
        t.activate(this, aOwner, aConnection);
        IId nid = CIdFactory.random((String)TRANSPORT);
        INamespace ns = this.mNamespaceFactory.createAndRegisterNamespace(nid, TRANSPORT);
        ns.getTargetRegistry().registerTarget((ITarget)t);
        LOG.debug("Transport target registered as {}", new Object[]{t.getAddress()});
        return t;
    }

    @Override
    public void deleteTransport(@NotNull ITransport aTransport) throws CException {
        CTargetAddress address = aTransport.getAddress();
        IId nid = address.getNID();
        ((CTransport)aTransport).deactivate();
        this.mNamespaceFactory.deleteNamespace(nid);
    }

    @Override
    @NotNull
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }

    @Override
    @NotNull
    public INameDb getNameDb() {
        return this.mNameDb;
    }

    @Override
    @NotNull
    public ITimerManager getTimerManager() {
        return this.mTimerManager;
    }

    @Override
    @NotNull
    public IMessageSender getMessageSender() {
        return this.mMessageSender;
    }

    @Override
    @NotNull
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }

    @Override
    @NotNull
    public IRouter getRouter() {
        return this.mRouter;
    }

    @Override
    @NotNull
    public INodeInfoDatabase getNodeInfoDatabase() {
        return this.mNodeInfoDatabase;
    }

    @Override
    @NotNull
    public IPacketFactoryRegistry getCentralPacketFactory() {
        return this.mCentralPacketFactory;
    }

    @Override
    @NotNull
    public IPacketConsumerRegistry getCentralPacketUtility() {
        return this.mCentralPacketUtility;
    }

    @Override
    @NotNull
    public ILinkCostTargetFactory getLinkCostTargetFactory() {
        return this.mLinkCostTargetFactory;
    }

    @Override
    @NotNull
    public IMicroServiceRegistryCollector getMicroServiceRegistryCollector() {
        return this.mMicroServiceRegistryCollector;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mNameDb = (INameDb)aServiceRegistry.getService(INameDb.class);
        this.mKernelConfiguration = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
        this.mTimerManager = (ITimerManager)aServiceRegistry.getServiceOrThrow(ITimerManager.class);
        this.mMessageSender = (IMessageSender)aServiceRegistry.getServiceOrThrow(IMessageSender.class);
        this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        this.mRouter = (IRouter)aServiceRegistry.getServiceOrThrow(IRouter.class);
        this.mNodeInfoDatabase = (INodeInfoDatabase)aServiceRegistry.getServiceOrThrow(INodeInfoDatabase.class);
        this.mCentralPacketFactory = (IPacketFactoryRegistry)aServiceRegistry.getServiceOrThrow(IPacketFactoryRegistry.class);
        this.mCentralPacketUtility = (IPacketConsumerRegistry)aServiceRegistry.getServiceOrThrow(IPacketConsumerRegistry.class);
        this.mLinkCostTargetFactory = (ILinkCostTargetFactory)aServiceRegistry.getServiceOrThrow(ILinkCostTargetFactory.class);
        this.mMicroServiceRegistryCollector = (IMicroServiceRegistryCollector)aServiceRegistry.getServiceOrThrow(IMicroServiceRegistryCollector.class);
        aServiceRegistry.registerService(ITransportFactory.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        aServiceRegistry.deregisterService((Object)this);
    }
}

