/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.router.target;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.network.nodeinfo.CNodeInfoUtil;
import de.sillysky.nyssr.impl.network.router.IInternalRouter;
import de.sillysky.nyssr.impl.network.router.target.CLinkCost;
import de.sillysky.nyssr.impl.network.router.target.CLocalConstants;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.network.link.cost.collector.records.CRecordBroadcastLinkCosts;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.network.router.CDijkstraLink;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetLinks;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetListOfLocalReachableNodeAddresses;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetListOfLocalReachableNodeInfos;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetListOfReachableNodes;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetNodeInfo;
import de.sillysky.nyssr.network.router.records.CRecordNetworkNotifyNodeLinkDeleted;
import de.sillysky.nyssr.network.router.records.CRecordNetworkNotifyUpdateNodeLinkList;
import de.sillysky.nyssr.network.router.records.CRecordNetworkRenewNodeRecord;
import de.sillysky.nyssr.network.router.records.CRecordNetworkUpdateDirectLinks;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CTargetForRouter
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForRouter.class);
    private INameDb mNameDb;
    private INodeInfoDatabase mNodeInfoDatabase;
    private IRouter mRouter;
    private IInternalRouter mInternalRouter;
    private IInternalRouter mPrivateRouter;
    private INamespaceFactory mNamespaceFactory;

    CTargetForRouter() {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkNotifyNodeLinkDeleted.ID, this::asyncDeletedNodeLink);
        this.addMessageHandler(CRecordNetworkNotifyUpdateNodeLinkList.ID, this::asyncNodeLinkList);
        this.addMessageHandler(CRecordNetworkRenewNodeRecord.ID, this::asyncRenewNodeRecord);
        this.addMessageHandler(CRecordNetworkGetNodeInfo.ID, this::asyncGetNodeInfo);
        this.addMessageHandler(CRecordNetworkGetListOfReachableNodes.ID, this::asyncGetListOfReachableNodes);
        this.addMessageHandler(CRecordNetworkGetListOfLocalReachableNodeAddresses.ID, this::asyncGetListOfLocalReachableNodeAddresses);
        this.addMessageHandler(CRecordNetworkGetListOfLocalReachableNodeInfos.ID, this::asyncGetListOfLocalReachableNodeInfos);
        this.addMessageHandler(CRecordNetworkUpdateDirectLinks.ID, this::asyncUpdateDirectLinks);
        this.addMessageHandler(CRecordBroadcastLinkCosts.ID, this::asyncBroadcastLinkCosts);
        this.addMessageHandler(CRecordNetworkGetLinks.ID, this::asyncGetLinks);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mNameDb = (INameDb)aServiceRegistry.getServiceOrThrow(INameDb.class);
        this.mRouter = (IRouter)aServiceRegistry.getServiceOrThrow(IRouter.class);
        this.mInternalRouter = (IInternalRouter)this.mRouter;
        this.mPrivateRouter = (IInternalRouter)aServiceRegistry.getServiceOrThrow(IInternalRouter.class);
        this.mNodeInfoDatabase = (INodeInfoDatabase)aServiceRegistry.getServiceOrThrow(INodeInfoDatabase.class);
        this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        INamespace ns = this.mNamespaceFactory.createAndRegisterNamespace(CLocalConstants.NID, "TRANSPORT");
        ns.getTargetRegistry().registerTarget((ITarget)this, CWellKnownTID.ROUTER);
        this.mPrivateRouter.internalSetTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        IInternalRouter privateRouter = (IInternalRouter)aServiceRegistry.getService(IInternalRouter.class);
        if (privateRouter != null) {
            privateRouter.internalSetTarget(null);
        }
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CTargetAddress address = this.getAddress();
        this.mNameDb.getTargetAddressDatabase().putName(address, "Router");
        INamespace ns = this.mNamespaceFactory.createAndRegisterNamespace(CWellKnownNID.SYSTEM, "SYSTEM");
        INanoServiceRegistry sr = ns.getNanoServiceRegistry();
        sr.addNanoServiceAndObserver(CRecordNetworkNotifyNodeLinkDeleted.class, address, false);
        sr.addNanoServiceAndObserver(CRecordNetworkNotifyUpdateNodeLinkList.class, address, false);
        sr.addNanoServiceAndObserver(CRecordNetworkGetNodeInfo.class, address, false);
        sr.addNanoServiceAndObserver(CRecordNetworkGetListOfReachableNodes.class, address, false);
        sr.addNanoServiceAndObserver(CRecordNetworkGetListOfLocalReachableNodeInfos.class, address, false);
        sr.addNanoServiceAndObserver(CRecordNetworkGetListOfLocalReachableNodeAddresses.class, address, false);
        sr.addNanoServiceAndObserver(CRecordNetworkUpdateDirectLinks.class, address, false);
        sr.addNanoServiceAndObserver(CRecordBroadcastLinkCosts.class, address, false);
        sr.addNanoServiceAndObserver(CRecordNetworkGetLinks.class, address, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDeletedNodeLink(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CNodeAddress node1 = CRecordNetworkNotifyNodeLinkDeleted.getNode1((CRecord)aRecord, null);
        CNodeAddress node2 = CRecordNetworkNotifyNodeLinkDeleted.getNode2((CRecord)aRecord, null);
        this.mPrivateRouter.internalDeleteNodeLink(node1, node2);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncUpdateDirectLinks(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordNetworkUpdateDirectLinks.getNode((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)node, (String)"Missing node", (Object[])new Object[0]);
        CRecord[] directLinks = CRecordNetworkUpdateDirectLinks.getDirectLinks((CRecord)aRecord, null);
        this.mPrivateRouter.updateDirectLinksForRemoteNode(node, directLinks);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetListOfReachableNodes(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        Collection nodes = this.mRouter.getReachableNodeAddresses();
        CNodeAddress[] arr = nodes.toArray(new CNodeAddress[0]);
        CRecordNetworkGetListOfReachableNodes.setNodes((CRecord)aRecord, (CNodeAddress[])arr);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetListOfLocalReachableNodeAddresses(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        Collection nodeInfos = this.mRouter.getReachableNodes();
        ArrayList<CNodeAddress> localNodes = new ArrayList<CNodeAddress>();
        for (CNodeInfo node : nodeInfos) {
            CNodeAddress nodeAddress = node.getNodeAddress();
            if (!nodeAddress.getSegmentId().isLocal()) continue;
            localNodes.add(nodeAddress);
        }
        CNodeAddress[] arr = localNodes.toArray(new CNodeAddress[0]);
        CRecordNetworkGetListOfLocalReachableNodeAddresses.setNodes((CRecord)aRecord, (CNodeAddress[])arr);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetListOfLocalReachableNodeInfos(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        Collection nodeInfos = this.mRouter.getReachableNodes();
        ArrayList<CRecord> localNodes = new ArrayList<CRecord>();
        for (CNodeInfo node : nodeInfos) {
            if (!node.getNodeAddress().getSegmentId().isLocal()) continue;
            CRecord record = node.toRecord();
            localNodes.add(record);
        }
        CRecord[] arr = localNodes.toArray(new CRecord[0]);
        CRecordNetworkGetListOfLocalReachableNodeInfos.setNodes((CRecord)aRecord, (CRecord[])arr);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetNodeInfo(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CNodeAddress[] nodes;
        ArrayList<CNodeAddress> filter = new ArrayList<CNodeAddress>();
        boolean isReachable = CRecordNetworkGetNodeInfo.getIsReachable((CRecord)aRecord, (boolean)false);
        CNodeAddress node = CRecordNetworkGetNodeInfo.getNode((CRecord)aRecord, null);
        if (node != null) {
            filter.add(node);
        }
        if ((nodes = CRecordNetworkGetNodeInfo.getNodes((CRecord)aRecord, null)) != null) {
            for (CNodeAddress adr : nodes) {
                if (adr == null) continue;
                filter.add(adr);
            }
        }
        Collection<CNodeAddress> idList = this.mPrivateRouter.internalGetReachableNodes(filter);
        ArrayList<CRecord> list = new ArrayList<CRecord>();
        this.privateGetRecords(list, idList);
        if (!isReachable) {
            idList = this.mPrivateRouter.internalGetUnreachableNodes(filter);
            this.privateGetRecords(list, idList);
        }
        int size = list.size();
        CRecord[] result = new CRecord[size];
        result = list.toArray(result);
        CRecordNetworkGetNodeInfo.setNodeInfos((CRecord)aRecord, (CRecord[])result);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNodeLinkList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord links = CRecordNetworkNotifyUpdateNodeLinkList.getLinks((CRecord)aRecord, null);
        this.mPrivateRouter.internalIncomingNodeLinkList(links);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRenewNodeRecord(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CNodeAddress remoteNode = aEnvelope.getSender().getNodeAddress();
        this.mNodeInfoDatabase.requestRemoteNodeInfo(remoteNode, true);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncBroadcastLinkCosts(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        ArrayList<CLinkCost> costEntries = new ArrayList<CLinkCost>();
        UUID[] connectionIds = CRecordBroadcastLinkCosts.getConnectionIds((CRecord)aRecord, null);
        int[] costs = CRecordBroadcastLinkCosts.getCosts((CRecord)aRecord, null);
        ZonedDateTime[] time = CRecordBroadcastLinkCosts.getTime((CRecord)aRecord, null);
        for (int i = 0; i < connectionIds.length; ++i) {
            costEntries.add(new CLinkCost(connectionIds[i], costs[i], time[i]));
        }
        if (!costEntries.isEmpty()) {
            this.mInternalRouter.internalUpdateCosts(costEntries);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetLinks(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        boolean onlyLocalSegment = CRecordNetworkGetLinks.getOnlyLocalSegment((CRecord)aRecord, (boolean)false);
        List<CDijkstraLink> links = this.mInternalRouter.internalGetLinkList();
        ArrayList<CRecord> records = new ArrayList<CRecord>();
        for (CDijkstraLink link : links) {
            if (onlyLocalSegment && (!link.getNode1().getSegmentId().isLocal() || !link.getNode2().getSegmentId().isLocal())) continue;
            records.add(link.toRecord());
        }
        CRecord[] arr = records.toArray(new CRecord[0]);
        CRecordNetworkGetLinks.setLinks((CRecord)aRecord, (CRecord[])arr);
        return true;
    }

    @Nullable
    private CRecord privateGetNodeInfo(@NotNull CNodeAddress aNode) throws CException {
        CNodeInfoDto info = this.mNodeInfoDatabase.getNodeInfo(aNode);
        if (info != null) {
            return CNodeInfoUtil.createRecord(info);
        }
        return null;
    }

    private void privateGetRecords(@NotNull List<CRecord> aResult, @NotNull Collection<CNodeAddress> aNodes) throws CException {
        for (CNodeAddress id : aNodes) {
            CRecord rec = this.privateGetNodeInfo(id);
            if (rec == null) continue;
            aResult.add(rec);
        }
    }
}

