/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.message;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.packet.factory.message.CStreamHeaderBasicMessage;
import de.sillysky.nyssr.impl.network.packet.factory.message.CStreamHeaderDebug;
import de.sillysky.nyssr.impl.network.packet.factory.message.CStreamHeaderMessagePayload;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.EPriority;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.network.packets.CPacketConstants;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacketBuilder;
import de.sillysky.nyssr.network.packets.IPacketBuilderRegistry;
import de.sillysky.nyssr.network.packets.IPacketMessage;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.util.files.CResourceHandler;
import de.sillysky.nyssr.util.streamheader.CStreamHeaderList;
import de.sillysky.nyssr.util.streamheader.IStreamHeader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import org.jetbrains.annotations.NotNull;

public final class CPacketMessage
implements IPacketMessage {
    private final INodeInfoDatabase mNodeInfoDatabase;
    private final CStreamHeaderList<CPacketMessage> mHeaderList;
    private final IPacketBuilderRegistry mPacketBuilderService;
    private CMessage mMessage;

    CPacketMessage(INodeInfoDatabase aNodeInfoDatabase, IPacketBuilderRegistry aPacketBuilderService, CMessage aMessage, int aSequenceNumber, CNodeAddress aLocalNode) {
        this.mNodeInfoDatabase = aNodeInfoDatabase;
        this.mPacketBuilderService = aPacketBuilderService;
        this.mMessage = aMessage;
        this.mHeaderList = new CStreamHeaderList();
        CEnvelope env = this.mMessage.getEnvelope();
        CStreamHeaderBasicMessage h1 = new CStreamHeaderBasicMessage(this);
        h1.setDestination(env.getReceiver().getNodeAddress());
        h1.setSource(aLocalNode);
        h1.setBuilderSequence("");
        h1.setPriority(env.getPriority());
        this.mHeaderList.add((IStreamHeader)h1);
        CStreamHeaderDebug h2 = new CStreamHeaderDebug(this);
        h2.setSequenceNumber(aSequenceNumber);
        this.mHeaderList.add((IStreamHeader)h2);
    }

    CPacketMessage(INodeInfoDatabase aNodeInfoDatabase, IPacketBuilderRegistry aPacketBuilderService, CStreamHeaderList<CPacketMessage> aHeaderList) {
        this.mNodeInfoDatabase = aNodeInfoDatabase;
        this.mPacketBuilderService = aPacketBuilderService;
        this.mHeaderList = aHeaderList;
    }

    @Override
    public void addHop(CNodeAddress aNode) {
        CStreamHeaderDebug h = (CStreamHeaderDebug)this.mHeaderList.getFirst(3);
        if (h != null) {
            h.addHop(aNode);
        }
    }

    @Override
    public String getBuilderSequence() {
        CStreamHeaderBasicMessage h = (CStreamHeaderBasicMessage)this.mHeaderList.getFirst(1);
        assert (h != null);
        return h.getBuilderSequence();
    }

    public void setBuilderSequence(String aSequence) {
        CStreamHeaderBasicMessage h = (CStreamHeaderBasicMessage)this.mHeaderList.getFirst(1);
        assert (h != null);
        h.setBuilderSequence(aSequence);
    }

    @Override
    public CNodeAddress getDestination() {
        CStreamHeaderBasicMessage h = (CStreamHeaderBasicMessage)this.mHeaderList.getFirst(1);
        assert (h != null);
        return h.getDestination();
    }

    @Override
    public CMessage getMessage() {
        return this.mMessage;
    }

    public void setMessage(CMessage aMessage) {
        this.mMessage = aMessage;
    }

    @Override
    public byte[] getPayload() {
        CStreamHeaderMessagePayload h = (CStreamHeaderMessagePayload)this.mHeaderList.getFirst(2);
        return h == null ? null : h.getPayload();
    }

    public void setPayload(byte[] aPayload) {
        CStreamHeaderMessagePayload h = (CStreamHeaderMessagePayload)this.mHeaderList.getFirst(2);
        if (h == null) {
            h = new CStreamHeaderMessagePayload(this);
            this.mHeaderList.add((IStreamHeader)h);
        }
        h.setPayload(aPayload);
    }

    @Override
    public EPriority getPriority() {
        CStreamHeaderBasicMessage h = (CStreamHeaderBasicMessage)this.mHeaderList.getFirst(1);
        assert (h != null);
        return h.getPriority();
    }

    int getSequenceNumber() {
        CStreamHeaderDebug h = (CStreamHeaderDebug)this.mHeaderList.getFirst(3);
        return h == null ? 0 : h.getSequenceNumber();
    }

    @Override
    public CNodeAddress getSource() {
        CStreamHeaderBasicMessage h = (CStreamHeaderBasicMessage)this.mHeaderList.getFirst(1);
        assert (h != null);
        return h.getSource();
    }

    @Override
    public EPacketType getType() {
        return EPacketType.MESSAGE;
    }

    @Override
    public void pack() throws CException {
        if (this.mMessage != null) {
            String sequence = this.mNodeInfoDatabase.getPacketBuilderSequence(this.mMessage);
            CNodeAddress remoteNode = this.mMessage.getEnvelope().getReceiver().getNodeAddress();
            CNodeInfoDto remote = this.mNodeInfoDatabase.getOrCreateNodeRecord(remoteNode);
            for (int i = 0; i < sequence.length(); ++i) {
                char c = sequence.charAt(i);
                IPacketBuilder builder = this.mPacketBuilderService.get(c);
                if (builder == null) continue;
                builder.pack(this, remote);
            }
        }
        this.pack2();
    }

    private void pack2() {
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(){

            protected byte[] doResourceHandling() throws Exception {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                this.registerResource(dos);
                dos.write(CPacketConstants.PACKET_HEADER);
                dos.write(EPacketType.MESSAGE.getValue());
                byte[] packedHeader = CPacketMessage.this.mHeaderList.pack();
                dos.write(packedHeader);
                dos.close();
                return baos.toByteArray();
            }
        };
        CResult error = handler.run();
        if (error != null) {
            handler.log();
        }
        this.setPayload((byte[])handler.getResult());
    }

    public void removeBuilderFlag(char aType) {
        CStreamHeaderBasicMessage h = (CStreamHeaderBasicMessage)this.mHeaderList.getFirst(1);
        assert (h != null);
        h.removeBuilderFlag(aType);
    }

    @NotNull
    public String toString() {
        return this.mHeaderList.toString();
    }

    @Override
    public void unpack() throws CException {
        CNodeAddress remoteNode = this.getSource();
        CNodeInfoDto remote = this.mNodeInfoDatabase.getOrCreateNodeRecord(remoteNode);
        String builderFlags = this.getBuilderSequence();
        char[] flags = builderFlags.toCharArray();
        for (int i = flags.length - 1; i >= 0; --i) {
            char flag = flags[i];
            IPacketBuilder builder = this.mPacketBuilderService.get(flag);
            if (builder == null) continue;
            builder.unpack(this, remote);
        }
    }

    @Override
    public int size() {
        return this.mHeaderList.size();
    }
}

