/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.platform;

import de.sillysky.nyssr.CBuildInfo;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.handler.registry.IMessageHandlerRegistry;
import de.sillysky.nyssr.message.handler.registry.IMessageHandlerRegistryFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.model.EPlatformType;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinPlatformContext;
import de.sillysky.nyssr.remoteskin.model.platform.IRemoteSkinPlatformRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.util.swing.CUtilSwing;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

class CRemoteSkinPlatformContextSwing
implements IRemoteSkinPlatformContext,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRemoteSkinPlatformContextSwing.class);
    private IMessageHandlerRegistry mMessageHandlerRegistry;

    CRemoteSkinPlatformContextSwing() {
    }

    static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IRemoteSkinPlatformRegistry.class);
        aDependencyList.add(IMessageHandlerRegistryFactory.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        IMessageHandlerRegistryFactory factory = (IMessageHandlerRegistryFactory)aServiceRegistry.getService(IMessageHandlerRegistryFactory.class);
        assert (factory != null);
        this.mMessageHandlerRegistry = factory.createMessageHandlerRegistry((Object)this);
        IRemoteSkinPlatformRegistry client = (IRemoteSkinPlatformRegistry)aServiceRegistry.getService(IRemoteSkinPlatformRegistry.class);
        assert (client != null);
        client.registerPlatform(EPlatformType.SWING.name(), (IRemoteSkinPlatformContext)this);
        if (CBuildInfo.getSourceCompatibility().equals("1.8")) {
            CUtilSwing.setFontSizeGlobal((int)14);
        }
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        IRemoteSkinPlatformRegistry client = (IRemoteSkinPlatformRegistry)aServiceRegistry.getService(IRemoteSkinPlatformRegistry.class);
        if (client != null) {
            client.deregisterPlatform(EPlatformType.SWING.name());
        }
    }

    public boolean handleMessage(@NotNull ITarget aTarget, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        return false;
    }

    public void invokeLater(@NotNull Runnable aRunnable) {
        SwingUtilities.invokeLater(aRunnable);
    }

    public void setLookAndFeel(@NotNull String aType) {
        try {
            UIManager.setLookAndFeel(aType);
        }
        catch (Exception e) {
            LOG.error("Error setting Look & Feel to {}: {}", new Object[]{aType, e.getMessage()});
        }
    }
}

