/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CSwingNode;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeNode;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Color;
import java.awt.Font;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CTreeNode {
    private final String mId;
    private final CEventIcon mEventIcon;
    private final LinkedList<CTreeNode> mChildren = new LinkedList();
    private final CSwingNode mSwingNode;
    private String mName;
    private ImageIcon mIcon;
    private CTreeNode mParent;
    private Color mBackground;
    private Color mForeground;
    private Border mBorder;
    private Font mFont;
    private String mTooltip = "";

    CTreeNode(@NotNull CEventTreeNode aNode) {
        this(aNode.getId(), aNode.getDisplayedText(), aNode.getIcon());
        String s;
        CEventFont font;
        IBorder border;
        CEventColor foreground;
        CEventColor background = aNode.getBackground();
        if (background != null) {
            this.mBackground = background.createColor();
        }
        if ((foreground = aNode.getForeground()) != null) {
            this.mForeground = foreground.createColor();
        }
        if ((border = aNode.getBorder()) != null) {
            this.mBorder = border.createBorder();
        }
        if ((font = aNode.getFont()) != null) {
            this.mFont = font.createFont();
        }
        this.mTooltip = (s = aNode.getTooltip()) == null ? "" : s;
    }

    public CTreeNode(@NotNull String aId, @Nullable String aName, @Nullable CEventIcon aEventIcon) {
        this.mId = aId;
        this.mName = CUtilString.isValid((String)aName) ? aName : this.mId;
        this.mEventIcon = aEventIcon;
        if (this.mEventIcon != null) {
            this.mIcon = this.mEventIcon.createIcon(this.getClass());
        }
        this.mParent = null;
        this.mSwingNode = new CSwingNode(this);
    }

    @NotNull
    CSwingNode getSwingNode() {
        return this.mSwingNode;
    }

    boolean contains(@NotNull String aChildId) {
        for (CTreeNode child : this.children()) {
            if (!child.getId().equals(aChildId)) continue;
            return true;
        }
        return false;
    }

    boolean contains(@NotNull CTreeNode aChild) {
        return this.mChildren.contains(aChild);
    }

    @NotNull
    public String getId() {
        return this.mId;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    void setName(@NotNull String aName) {
        this.mName = aName;
    }

    @Nullable
    public ImageIcon getIcon() {
        return this.mIcon;
    }

    @Nullable
    public CEventIcon getIconEvent() {
        return this.mEventIcon;
    }

    @Nullable
    public CTreeNode getParent() {
        return this.mParent;
    }

    public void setParent(@Nullable CTreeNode aParent) {
        this.mParent = aParent;
    }

    public void addChild(@NotNull CTreeNode aNode) {
        this.mChildren.add(aNode);
    }

    public void linkChild(@NotNull CTreeNode aNode) {
        this.mChildren.add(aNode);
        aNode.setParent(this);
    }

    public void removeChild(@NotNull CTreeNode aNode) {
        this.mChildren.remove(aNode);
        aNode.setParent(null);
    }

    @NotNull
    public LinkedList<CTreeNode> children() {
        return this.mChildren;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CTreeNode that = (CTreeNode)aO;
        return Objects.equals(this.mId, that.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    public String toString() {
        return this.mName;
    }

    Color getBackground() {
        return this.mBackground;
    }

    void setBackground(Color aBackground) {
        this.mBackground = aBackground;
    }

    Color getForeground() {
        return this.mForeground;
    }

    Border getBorder() {
        return this.mBorder;
    }

    Font getFont() {
        return this.mFont;
    }

    @NotNull
    String getTooltip() {
        return this.mTooltip;
    }

    @NotNull
    TreePath getTreePath() {
        return new TreePath(this.mSwingNode.getPath());
    }
}

