/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.spinner;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingSlider;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.spinner.CSwingSpinner;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventDateFormat;
import de.sillysky.nyssr.remoteskin.model.events.CEventLocalDateTime;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.swing.time.CUtilCalendarUnit;
import de.sillysky.nyssr.util.time.CUtilDate;
import de.sillysky.nyssr.util.time.CUtilLocalDateTime;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingDateSpinner
extends CSwingSpinner {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingSlider.class);
    private String mPattern = null;

    public CSwingDateSpinner(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        LocalDateTime now = LocalDateTime.now();
        Date date = CUtilDate.fromLocalDateTime((LocalDateTime)now);
        SpinnerDateModel model = new SpinnerDateModel(date, null, null, 6);
        this.getComponent().setModel(model);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("minimum", this::applyMinimum);
        list.addHandler("minimumDate", this::applyMinimum);
        list.addHandler("maximum", this::applyMaximum);
        list.addHandler("maximumDate", this::applyMaximum);
        list.addHandler("value", this::applyDate);
        list.addHandler("date", this::applyDate);
        list.addHandler("dateTimeFormat", this::applyDateFormat);
        list.addHandler("calendarUnit", this::applyCalendarUnit);
    }

    @Override
    public void addListeners() {
        super.addListeners();
        this.getComponent().addChangeListener(this::onChange);
    }

    private boolean applyCalendarUnit(@NotNull String aKey, @Nullable Object aValue) {
        Integer unit;
        String calendarUnit;
        if (aValue instanceof String && (calendarUnit = CUtilString.fromObject((Object)aValue, (String)"")) != null && (unit = CUtilCalendarUnit.getMap().get(calendarUnit)) != null) {
            LOG.debug("DateSpinner: set CalendarUnit to {}", new Object[]{calendarUnit});
            this.getDateModel().setCalendarField(unit);
            return true;
        }
        return false;
    }

    private boolean applyDateFormat(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            this.mPattern = CUtilString.fromObject((Object)aValue, (String)"Dd.Mm.yyyy");
            LOG.debug("Set Spinner Editor DateTimeFormat to {}", new Object[]{this.mPattern});
            JSpinner component = this.getComponent();
            JSpinner.DateEditor de = new JSpinner.DateEditor(component, this.mPattern);
            component.setEditor(de);
            component.repaint();
            return true;
        }
        return false;
    }

    private boolean applyDate(@NotNull String aKey, @Nullable Object aValue) {
        CEventDateFormat event = CEventDateFormat.create((Object)aValue);
        if (event != null) {
            LocalDate localDate = event.createLocalDate();
            Date date = CUtilDate.fromLocalDate((LocalDate)localDate);
            SpinnerDateModel model = this.getDateModel();
            this.startEdit();
            model.setValue(date);
            this.stopEdit();
            return true;
        }
        return false;
    }

    private boolean applyMinimum(@NotNull String aKey, @Nullable Object aValue) {
        CEventDateFormat event = CEventDateFormat.create((Object)aValue);
        if (event != null) {
            LocalDate localDate = event.createLocalDate();
            Date date = CUtilDate.fromLocalDate((LocalDate)localDate);
            SpinnerDateModel model = this.getDateModel();
            model.setStart(date);
            return true;
        }
        return false;
    }

    private boolean applyMaximum(@NotNull String aKey, @Nullable Object aValue) {
        CEventDateFormat event = CEventDateFormat.create((Object)aValue);
        if (event != null) {
            LocalDate localDate = event.createLocalDate();
            Date date = CUtilDate.fromLocalDate((LocalDate)localDate);
            SpinnerDateModel model = this.getDateModel();
            model.setEnd(date);
            return true;
        }
        return false;
    }

    @Override
    protected String getValueString() {
        Date value = (Date)this.getComponent().getValue();
        if (CUtilString.isValid((String)this.mPattern)) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.mPattern);
            return sdf.format(value);
        }
        DateFormat di = DateFormat.getDateInstance(3);
        return di.format(value);
    }

    private SpinnerDateModel getDateModel() {
        return (SpinnerDateModel)this.getComponent().getModel();
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.DateSpinner.name();
    }

    @Override
    protected void onChange(@NotNull ChangeEvent aEvent) {
        if (this.isOnChange() && !this.isEditInProgress()) {
            SpinnerDateModel model = this.getDateModel();
            Date value = model.getDate();
            LocalDateTime date = CUtilLocalDateTime.fromDate((Date)value);
            LOG.debug("value is {}", new Object[]{value});
            CEventLocalDateTime event = new CEventLocalDateTime(date);
            this.addNotification("onChangeDate", event.toJson());
            this.sendNotification();
        }
    }
}

