/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingContainer;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CUtilReference;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventBevelBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventBubbleBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventCompoundBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventDashedBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventEmptyBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventEtchedBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventLineBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventMatteBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventStrokeBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CEventTitledBorder;
import de.sillysky.nyssr.remoteskin.model.events.border.CJsonBorderUtil;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import de.sillysky.nyssr.util.CUtilFloat;
import de.sillysky.nyssr.util.CUtilInteger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CSwingJComponent
extends CSwingContainer {
    public static final int INVALID_INT = -9999;
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingJComponent.class);

    public CSwingJComponent(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("alignmentX", this::applyAlignmentX);
        list.addHandler("alignmentY", this::applyAlignmentY);
        list.addHandler("background", this::applyBackground);
        list.addHandler("border", this::applyBorder);
        list.addHandler("compoundBorder", this::applyCompoundBorder);
        list.addHandler("emptyBorder", this::applyEmptyBorder);
        list.addHandler("dashedBorder", this::applyDashedBorder);
        list.addHandler("lineBorder", this::applyLineBorder);
        list.addHandler("bevelBorder", this::applyBevelBorder);
        list.addHandler("etchedBorder", this::applyEtchedBorder);
        list.addHandler("matteBorder", this::applyMatteBorder);
        list.addHandler("strokeBorder", this::applyStrokeBorder);
        list.addHandler("titledBorder", this::applyTitledBorder);
        list.addHandler("bubbleBorder", this::applyBubbleBorder);
        list.addHandler("foreground", this::applyForeground);
        list.addHandler("font", this::applyFont);
        list.addHandler("height", this::applyHeight);
        list.addHandler("noBorder", this::applyNoBorder);
        list.addHandler("onResizeParent", this::applyOnResizeParent);
        list.addHandler("opaque", this::applySetOpaque);
        list.addHandler("title", this::applySetTitle);
        list.addHandler("width", this::applyWidth);
        list.addHandler("debugBox", this::applyDebugBox);
        list.addHandler("display", this::applyDisplay);
        list.addHandler("tooltip", this::applyTooltip);
    }

    private boolean applyTooltip(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String tt = (String)aValue;
            LOG.debug("Set Tooltip to {}", new Object[]{tt});
            Component c = this.getComponent();
            if (c instanceof JComponent) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    private boolean applyDisplay(@NotNull String aKey, @Nullable Object aValue) {
        CWidgetId wid = CUtilReference.parse((Object)aValue, (Object[])new Object[0]);
        if (wid != null) {
            this.getProperties().put("display", wid);
            return true;
        }
        return false;
    }

    private boolean applyDebugBox(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean debug = (Boolean)aValue;
            if (debug) {
                JComponent comp = (JComponent)this.getComponent();
                comp.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
            }
            return true;
        }
        return false;
    }

    private boolean applyAlignmentX(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            float f = CUtilFloat.fromObject((Object)aValue);
            LOG.debug("Set {} to {}", new Object[]{aKey, Float.valueOf(f)});
            JComponent comp = (JComponent)this.getComponent();
            comp.setAlignmentX(f);
            return true;
        }
        return false;
    }

    private boolean applyAlignmentY(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            float f = CUtilFloat.fromObject((Object)aValue);
            LOG.debug("Set {} to {}", new Object[]{aKey, Float.valueOf(f)});
            JComponent comp = (JComponent)this.getComponent();
            comp.setAlignmentY(f);
            return true;
        }
        return false;
    }

    private boolean applyBackground(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event;
        Container contentPane = this.getContentPane();
        if (contentPane != null && (event = CEventColor.create((Object)aValue)) != null) {
            contentPane.setBackground(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyBorder(@NotNull String aKey, @Nullable Object aValue) {
        IBorder border = CJsonBorderUtil.create((Object)aValue);
        if (border != null) {
            JComponent comp = (JComponent)this.getComponent();
            comp.setBorder(border.createBorder());
            return true;
        }
        return false;
    }

    private boolean applyCompoundBorder(@NotNull String aKey, @Nullable Object aValue) {
        CEventCompoundBorder event = CEventCompoundBorder.create((Object)aValue);
        if (event != null) {
            JComponent comp = (JComponent)this.getComponent();
            comp.setBorder(event.createBorder());
            return true;
        }
        return false;
    }

    private boolean applyEmptyBorder(@NotNull String aKey, @Nullable Object aValue) {
        CEventEmptyBorder event = CEventEmptyBorder.create((Object)aValue);
        if (event != null) {
            Border border = event.createBorder();
            JComponent comp = (JComponent)this.getComponent();
            comp.setBorder(border);
            return true;
        }
        return false;
    }

    private boolean applyDashedBorder(@NotNull String aKey, @Nullable Object aValue) {
        CEventDashedBorder event = CEventDashedBorder.create((Object)aValue);
        if (event != null) {
            Border border = event.createBorder();
            JComponent comp = (JComponent)this.getComponent();
            comp.setBorder(border);
            return true;
        }
        return false;
    }

    private boolean applyLineBorder(@NotNull String aKey, @Nullable Object aValue) {
        CEventLineBorder event = CEventLineBorder.create((Object)aValue);
        if (event != null) {
            Border border = event.createBorder();
            JComponent comp = (JComponent)this.getComponent();
            comp.setBorder(border);
            return true;
        }
        return false;
    }

    private boolean applyBevelBorder(@NotNull String aKey, @Nullable Object aValue) {
        CEventBevelBorder event = CEventBevelBorder.create((Object)aValue);
        if (event != null) {
            Border border = event.createBorder();
            JComponent comp = (JComponent)this.getComponent();
            comp.setBorder(border);
            return true;
        }
        return false;
    }

    private boolean applyEtchedBorder(@NotNull String aKey, @Nullable Object aValue) {
        CEventEtchedBorder event = CEventEtchedBorder.create((Object)aValue);
        if (event != null) {
            Border border = event.createBorder();
            JComponent comp = (JComponent)this.getComponent();
            comp.setBorder(border);
            return true;
        }
        return false;
    }

    private boolean applyMatteBorder(@NotNull String aKey, @Nullable Object aValue) {
        CEventMatteBorder event = CEventMatteBorder.create((Object)aValue);
        if (event != null) {
            Border border = event.createBorder();
            JComponent comp = (JComponent)this.getComponent();
            comp.setBorder(border);
            return true;
        }
        return false;
    }

    private boolean applyStrokeBorder(@NotNull String aKey, @Nullable Object aValue) {
        CEventStrokeBorder event = CEventStrokeBorder.create((Object)aValue);
        if (event != null) {
            Border border = event.createBorder();
            JComponent comp = (JComponent)this.getComponent();
            comp.setBorder(border);
            return true;
        }
        return false;
    }

    private boolean applyTitledBorder(@NotNull String aKey, @Nullable Object aValue) {
        CEventTitledBorder event = CEventTitledBorder.create((Object)aValue);
        if (event != null) {
            Border border = event.createBorder();
            JComponent comp = (JComponent)this.getComponent();
            comp.setBorder(border);
            return true;
        }
        return false;
    }

    private boolean applyBubbleBorder(@NotNull String aKey, @Nullable Object aValue) {
        CEventBubbleBorder event = CEventBubbleBorder.create((Object)aValue);
        if (event != null) {
            Border border = event.createBorder();
            JComponent comp = (JComponent)this.getComponent();
            comp.setBorder(border);
            return true;
        }
        return false;
    }

    private boolean applyFont(@NotNull String aKey, @Nullable Object aValue) {
        CEventFont event = CEventFont.create((Object)aValue);
        if (event != null) {
            Font font = event.createFont();
            LOG.debug("Set attribute {} = {}", new Object[]{aKey, font});
            JComponent comp = (JComponent)this.getComponent();
            comp.setFont(font);
            return true;
        }
        return false;
    }

    private boolean applyForeground(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            LOG.debug("Set {} to {}", new Object[]{aKey, event.createColor()});
            JComponent comp = (JComponent)this.getComponent();
            comp.setForeground(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyHeight(@NotNull String aKey, @Nullable Object aValue) {
        int height = CUtilInteger.fromObject((Object)aValue, (int)-9999);
        if (height != -9999 && height >= 0) {
            JComponent comp = (JComponent)this.getComponent();
            int width = comp.getWidth();
            LOG.debug("Set {} to {}", new Object[]{aKey, height});
            comp.setSize(width, height);
            return true;
        }
        return false;
    }

    private boolean applyNoBorder(@NotNull String aKey, @Nullable Object aValue) {
        JComponent comp = (JComponent)this.getComponent();
        LOG.debug("Set {} to {}", new Object[]{aKey, true});
        comp.setBorder(null);
        return true;
    }

    private boolean applyOnResizeParent(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String value = (String)aValue;
            Component component = this.getComponent();
            if (component instanceof JComponent) {
                JComponent comp = (JComponent)component;
                String[] split = value.split(",");
                if (split.length == 3 && CUtilReference.isWidgetId((String)split[0])) {
                    String refId = CUtilReference.stripPrefix((String)split[0]);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean applySetOpaque(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean opaque = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, opaque});
            ((JComponent)this.getComponent()).setOpaque(opaque);
            return true;
        }
        return false;
    }

    private boolean applySetTitle(@NotNull String aKey, @Nullable Object aValue) {
        return true;
    }

    private boolean applyWidth(@NotNull String aKey, @Nullable Object aValue) {
        int width;
        if (aValue instanceof Number && (width = CUtilInteger.fromObject((Object)aValue, (int)-9999)) != -9999) {
            JComponent co = (JComponent)this.getComponent();
            int height = co.getHeight();
            LOG.debug("Set {} to {}", new Object[]{aKey, width});
            co.setSize(width, height);
            return true;
        }
        return false;
    }

    public void notifyComponentCreated() {
        super.notifyComponentCreated();
        Component component = this.getComponent();
    }
}

